import Meta from '../meta';
import { VOLATILE_TAG } from '@glimmer/reference';
export class PropertyReference {
    constructor(object, property, outer) {
        this.tag = VOLATILE_TAG;
        this.object = object;
        this.property = property;
    }
    value() { return this.object[this.property]; }
    label() {
        return '[reference Property]';
    }
}
export function ComputedReferenceBlueprint(property, dependencies) {
    return class ComputedReference {
        constructor(object, property, outer) {
            this.installed = false;
            this.tag = VOLATILE_TAG;
            this.object = object;
            this.property = property;
            this.dependencies = dependencies;
            this.outer = outer;
        }
        value() {
            if (!this.installed) {
                let root = Meta.for(this.object).root();
                this.dependencies.forEach(dep => {
                    let ref = root.referenceFromParts(dep);
                    ref.value();
                });
                this.installed = true;
            }
            return this.object[this.property];
        }
        label() {
            return '[reference Computed]';
        }
    };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVzY3JpcHRvcnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9saWIvcmVmZXJlbmNlcy9kZXNjcmlwdG9ycy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLElBQUksTUFBTSxTQUFTLENBQUM7QUFDM0IsT0FBTyxFQUFhLFlBQVksRUFBZSxNQUFNLG9CQUFvQixDQUFDO0FBTzFFLE1BQU07SUFLSixZQUFZLE1BQVcsRUFBRSxRQUFnQixFQUFFLEtBQTZCO1FBRmpFLFFBQUcsR0FBZ0IsWUFBWSxDQUFDO1FBR3JDLElBQUksQ0FBQyxNQUFNLEdBQUcsTUFBTSxDQUFDO1FBQ3JCLElBQUksQ0FBQyxRQUFRLEdBQUcsUUFBUSxDQUFDO0lBQzNCLENBQUM7SUFFRCxLQUFLLEtBQUssTUFBTSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUU5QyxLQUFLO1FBQ0gsTUFBTSxDQUFDLHNCQUFzQixDQUFDO0lBQ2hDLENBQUM7Q0FDRjtBQUVELE1BQU0scUNBQXdDLFFBQVEsRUFBRSxZQUFZO0lBQ2xFLE1BQU0sQ0FBQztRQVFMLFlBQVksTUFBVyxFQUFFLFFBQWdCLEVBQUUsS0FBNkI7WUFIaEUsY0FBUyxHQUFHLEtBQUssQ0FBQztZQUNuQixRQUFHLEdBQWdCLFlBQVksQ0FBQztZQUdyQyxJQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQztZQUNyQixJQUFJLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQztZQUN6QixJQUFJLENBQUMsWUFBWSxHQUFHLFlBQVksQ0FBQztZQUNqQyxJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztRQUNyQixDQUFDO1FBRUQsS0FBSztZQUNILEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7Z0JBQ3BCLElBQUksSUFBSSxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLElBQUksRUFBRSxDQUFDO2dCQUV4QyxJQUFJLENBQUMsWUFBWSxDQUFDLE9BQU8sQ0FBQyxHQUFHO29CQUMzQixJQUFJLEdBQUcsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsR0FBRyxDQUFDLENBQUM7b0JBQ3ZDLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQztnQkFDZCxDQUFDLENBQUMsQ0FBQztnQkFFSCxJQUFJLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQztZQUN4QixDQUFDO1lBRUQsTUFBTSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ3BDLENBQUM7UUFFRCxLQUFLO1lBQ0gsTUFBTSxDQUFDLHNCQUFzQixDQUFDO1FBQ2hDLENBQUM7S0FDRixDQUFDO0FBQ0osQ0FBQyJ9