"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const object_reference_1 = require("@glimmer/object-reference");
const object_1 = require("./object");
const mixin_1 = require("./mixin");
class ComputedBlueprint extends mixin_1.Blueprint {
    constructor(accessor, deps = []) {
        super();
        this.metadata = {};
        this.accessor = accessor;
        this.deps = deps;
    }
    descriptor(target, key, classMeta) {
        classMeta.addReferenceTypeFor(key, object_reference_1.ComputedReferenceBlueprint(key, this.deps));
        classMeta.addPropertyMetadata(key, this.metadata);
        classMeta.addSlotFor(key);
        return new Computed(this.accessor);
    }
    property(...paths) {
        this.deps = paths.map(d => d.split('.'));
        return this;
    }
    meta(object) {
        this.metadata = object;
        return this;
    }
    volatile() {
        return this;
    }
}
exports.ComputedBlueprint = ComputedBlueprint;
class Computed {
    constructor(accessor) {
        this["5d90f84f-908e-4a42-9749-3d0f523c262c"] = true;
        this.accessor = accessor;
    }
    define(prototype, key, home) {
        Object.defineProperty(prototype, key, wrapAccessor(home, key, this.accessor));
    }
}
function wrapAccessor(home, accessorName, _desc) {
    let superDesc = getPropertyDescriptor(home, accessorName);
    let originalGet;
    let originalSet;
    let desc = {
        enumerable: true,
        configurable: true,
    };
    if (_desc.get && _desc.get.length > 0) {
        originalGet = function () { return _desc.get.call(this, accessorName); };
    }
    else {
        originalGet = _desc.get;
    }
    if (_desc.set && _desc.set.length > 1) {
        originalSet = function (value) {
            return _desc.set.call(this, accessorName, value);
        };
    }
    else {
        originalSet = _desc.set;
    }
    let cacheGet = function () {
        if (object_reference_1.Meta.exists(this)) {
            let slot = object_reference_1.Meta.for(this).getSlots()[accessorName];
            if (slot !== object_1.EMPTY_CACHE)
                return slot;
        }
        return originalGet.call(this);
    };
    let cacheSet;
    if (originalSet) {
        cacheSet = function (value) {
            let meta = object_reference_1.Meta.for(this);
            let slots = meta.getSlots();
            let ret = originalSet.call(this, value);
            if (ret !== undefined) {
                slots[accessorName] = ret;
            }
        };
    }
    else {
        cacheSet = function (value) {
            let meta = object_reference_1.Meta.for(this);
            let slots = meta.getSlots();
            if (value !== undefined)
                slots[accessorName] = value;
        };
    }
    if (!superDesc || 'value' in superDesc) {
        desc.get = cacheGet;
        desc.set = cacheSet;
        return desc;
    }
    desc.get = function () {
        let lastSuper = this._super;
        this._super = function () {
            return superDesc.get.call(this);
        };
        try {
            return cacheGet.call(this);
        }
        finally {
            this._super = lastSuper;
        }
    };
    desc.set = function (val) {
        let lastSuper = this._super;
        this._super = function () {
            return superDesc.set.call(this, val);
        };
        try {
            return cacheSet.call(this, val);
        }
        finally {
            this._super = lastSuper;
        }
    };
    return desc;
}
function getPropertyDescriptor(subject, name) {
    let pd = Object.getOwnPropertyDescriptor(subject, name);
    let proto = Object.getPrototypeOf(subject);
    while (typeof pd === 'undefined' && proto !== null) {
        pd = Object.getOwnPropertyDescriptor(proto, name);
        proto = Object.getPrototypeOf(proto);
    }
    return pd;
}
function computed(...args) {
    let last = args.pop();
    let deps = args;
    if (typeof last === 'function') {
        return new ComputedBlueprint({
            get: last
        }).property(...deps);
    }
    else if (typeof last === 'object') {
        return new ComputedBlueprint(last).property(...deps);
    }
    else {
        throw new TypeError("computed expects a function or an object as last argument");
    }
}
exports.computed = computed;
function observer(...args) {
}
exports.observer = observer;
//# sourceMappingURL=data:application/json;base64,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