"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mixin_1 = require("./mixin");
const computed_1 = require("./computed");
class AliasMethodDescriptor extends mixin_1.Descriptor {
    constructor(name) {
        super();
        this.name = name;
    }
    define(target, key, home) {
        let name = this.name;
        Object.defineProperty(target, key, {
            enumerable: true,
            configurable: true,
            get() {
                return this[name];
            }
        });
    }
}
class AliasMethodBlueprint extends mixin_1.Blueprint {
    constructor(name) {
        super();
        this.name = name;
    }
    descriptor(target, key, meta) {
        return new AliasMethodDescriptor(this.name);
    }
}
function aliasMethod(name) {
    return new AliasMethodBlueprint(name);
}
exports.aliasMethod = aliasMethod;
class AliasBlueprint extends computed_1.ComputedBlueprint {
    constructor(name) {
        let parent = name.slice(0, -1);
        let last = name[name.length - 1];
        let get = function () {
            return name.reduce((obj, n) => obj[n], this);
        };
        let set = function (value) {
            let p = parent.reduce((obj, n) => obj[n], this);
            p[last] = value;
        };
        super({ get, set }, [name]);
        this.name = name;
    }
    descriptor(target, key, meta) {
        if (this.name[0] === key)
            throw new Error(`Setting alias '${key}' on self`);
        return super.descriptor(target, key, meta);
    }
}
function alias(name) {
    return new AliasBlueprint(name.split('.'));
}
exports.alias = alias;
//# sourceMappingURL=data:application/json;base64,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