import GlimmerObject, { GlimmerObjectFactory, ClassMeta } from './object';
export declare const DESCRIPTOR = "5d90f84f-908e-4a42-9749-3d0f523c262c";
export declare const BLUEPRINT = "8d97cf5f-db9e-48d8-a6b2-7a75b7170805";
export declare abstract class Descriptor {
    "5d90f84f-908e-4a42-9749-3d0f523c262c": boolean;
    abstract define(prototype: Object, key: string, home: Object): any;
}
export declare abstract class Blueprint {
    "8d97cf5f-db9e-48d8-a6b2-7a75b7170805": boolean;
    abstract descriptor(target: Object, key: string, classMeta: ClassMeta): Descriptor;
}
export interface Extensions {
    concatenatedProperties?: string[] | string;
    mergedProperties?: string[] | string;
    _super?: Function;
    [index: string]: any;
}
export declare class Mixin {
    private extensions;
    private concatenatedProperties;
    private mergedProperties;
    private dependencies;
    static create(...args: (Mixin | Extensions)[]): Mixin;
    static mixins(obj: any): Mixin[];
    constructor(extensions: Extensions, mixins: Mixin[]);
    detect(obj: any): boolean;
    reopen(extensions: Extensions): void;
    apply(target: any): any;
    extendPrototype(Original: GlimmerObjectFactory<any>): void;
    extendPrototypeOnto(Subclass: GlimmerObjectFactory<any>, Parent: GlimmerObjectFactory<any>): void;
    extendStatic(Target: GlimmerObjectFactory<any>): void;
    mergeProperties(target: Object, parent: Object, meta: ClassMeta): void;
}
export declare type Extension = Mixin | Extensions;
export declare function extend<T extends GlimmerObject>(Parent: GlimmerObjectFactory<T>, ...extensions: Extension[]): typeof GlimmerObject;
export declare function relinkSubclasses(Parent: GlimmerObjectFactory<any>): void;
export declare function toMixin(extension: Extension): Mixin;
export declare class DataBlueprint extends Blueprint {
    enumerable: boolean;
    configurable: boolean;
    value: any;
    writable: boolean;
    constructor({enumerable, configurable, writable, value}: PropertyDescriptor);
    descriptor(target: Object, key: string, classMeta: ClassMeta): Descriptor;
}
export declare abstract class AccessorBlueprint extends Blueprint {
    enumerable: boolean;
    configurable: boolean;
    get: () => any;
    set: (value: any) => void;
    constructor({enumerable, configurable, get, set}: PropertyDescriptor);
    descriptor(target: Object, key: string, classMeta: ClassMeta): Descriptor;
}
export declare function wrapMethod(home: Object, methodName: string, original: (...args) => any): Function;
