"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const object_reference_1 = require("@glimmer/object-reference");
const util_1 = require("@glimmer/util");
const object_1 = require("./object");
const utils_1 = require("./utils");
const { isArray } = Array;
exports.DESCRIPTOR = "5d90f84f-908e-4a42-9749-3d0f523c262c";
exports.BLUEPRINT = "8d97cf5f-db9e-48d8-a6b2-7a75b7170805";
class Descriptor {
    constructor() {
        this["5d90f84f-908e-4a42-9749-3d0f523c262c"] = true;
    }
}
exports.Descriptor = Descriptor;
class Blueprint {
    constructor() {
        this["8d97cf5f-db9e-48d8-a6b2-7a75b7170805"] = true;
    }
}
exports.Blueprint = Blueprint;
class Mixin {
    constructor(extensions, mixins) {
        this.extensions = null;
        this.concatenatedProperties = [];
        this.mergedProperties = [];
        this.dependencies = [];
        this.reopen(extensions);
        this.dependencies.push(...mixins);
    }
    static create(...args) {
        let extensions = args[args.length - 1];
        if (args.length === 0) {
            return new this({}, []);
        }
        else if (extensions instanceof Mixin) {
            return new this({}, args);
        }
        else {
            let deps = args.slice(0, -1).map(toMixin);
            return new this(extensions, deps);
        }
    }
    static mixins(obj) {
        if (typeof obj !== 'object' || obj === null)
            return [];
        let meta = object_1.ClassMeta.for(obj);
        if (!meta)
            return [];
        return meta.getAppliedMixins();
    }
    detect(obj) {
        if (typeof obj !== 'object' || obj === null)
            return false;
        if (obj instanceof Mixin) {
            return obj.dependencies.indexOf(this) !== -1;
        }
        let meta = object_1.ClassMeta.for(obj);
        return !!meta && meta.hasAppliedMixin(this);
    }
    reopen(extensions) {
        if (this.extensions) {
            this.dependencies.push(toMixin(this.extensions));
        }
        if (typeof extensions === 'object' && 'concatenatedProperties' in extensions) {
            let concat;
            let rawConcat = extensions.concatenatedProperties;
            if (isArray(rawConcat)) {
                concat = rawConcat.slice();
            }
            else if (rawConcat === null || rawConcat === undefined) {
                concat = [];
            }
            else {
                concat = [rawConcat];
            }
            delete extensions.concatenatedProperties;
            this.concatenatedProperties = concat;
        }
        if (typeof extensions === 'object' && 'mergedProperties' in extensions) {
            let merged;
            let rawMerged = extensions.mergedProperties;
            if (isArray(rawMerged)) {
                merged = rawMerged.slice();
            }
            else if (rawMerged === null || rawMerged === undefined) {
                merged = [];
            }
            else {
                merged = [rawMerged];
            }
            delete extensions.mergedProperties;
            this.mergedProperties = merged;
        }
        let normalized = Object.keys(extensions).reduce((obj, key) => {
            let value = extensions[key];
            switch (typeof value) {
                case 'function':
                    obj[key] = new MethodBlueprint({ value });
                    break;
                case 'object':
                    if (value && exports.BLUEPRINT in value) {
                        obj[key] = value;
                        break;
                    }
                /* falls through */
                default:
                    obj[key] = new DataBlueprint({ value });
            }
            return obj;
        }, util_1.dict());
        this.extensions = util_1.dict();
        util_1.assign(this.extensions, object_1.turbocharge(normalized));
    }
    apply(target) {
        let meta = target[object_reference_1.CLASS_META] = target[object_reference_1.CLASS_META] || new object_1.ClassMeta();
        this.dependencies.forEach(m => m.apply(target));
        this.mergeProperties(target, target, meta);
        meta.addMixin(this);
        meta.seal();
        meta.reseal(target);
        return target;
    }
    extendPrototype(Original) {
        Original.prototype = Object.create(Original.prototype);
        this.dependencies.forEach(m => m.extendPrototype(Original));
        this.extendPrototypeOnto(Original, Original);
    }
    extendPrototypeOnto(Subclass, Parent) {
        this.dependencies.forEach(m => m.extendPrototypeOnto(Subclass, Parent));
        this.mergeProperties(Subclass.prototype, Parent.prototype, Subclass[object_reference_1.CLASS_META]);
        Subclass[object_reference_1.CLASS_META].addMixin(this);
    }
    extendStatic(Target) {
        this.dependencies.forEach(m => m.extendStatic(Target));
        this.mergeProperties(Target, Object.getPrototypeOf(Target), Target[object_reference_1.CLASS_META][object_reference_1.CLASS_META]);
        Target[object_reference_1.CLASS_META].addStaticMixin(this);
    }
    mergeProperties(target, parent, meta) {
        if (meta.hasAppliedMixin(this))
            return;
        meta.addAppliedMixin(this);
        this.mergedProperties.forEach(k => meta.addMergedProperty(k, parent[k]));
        this.concatenatedProperties.forEach(k => meta.addConcatenatedProperty(k, []));
        new ValueDescriptor({ value: meta.getConcatenatedProperties() }).define(target, 'concatenatedProperties', null);
        new ValueDescriptor({ value: meta.getMergedProperties() }).define(target, 'mergedProperties', null);
        Object.keys(this.extensions).forEach(key => {
            let extension = this.extensions[key];
            let desc = extension.descriptor(target, key, meta);
            desc.define(target, key, parent);
        });
        new ValueDescriptor({ value: utils_1.ROOT }).define(target, '_super', null);
    }
}
exports.Mixin = Mixin;
function extend(Parent, ...extensions) {
    let Super = Parent;
    let Subclass = class extends Super {
    };
    Subclass[object_reference_1.CLASS_META] = object_1.InstanceMeta.fromParent(Parent[object_reference_1.CLASS_META]);
    let mixins = extensions.map(toMixin);
    Parent[object_reference_1.CLASS_META].addSubclass(Subclass);
    mixins.forEach(m => Subclass[object_reference_1.CLASS_META].addMixin(m));
    object_1.ClassMeta.applyAllMixins(Subclass, Parent);
    return Subclass;
}
exports.extend = extend;
function relinkSubclasses(Parent) {
    Parent[object_reference_1.CLASS_META].getSubclasses().forEach((Subclass) => {
        Subclass[object_reference_1.CLASS_META].reset(Parent[object_reference_1.CLASS_META]);
        Subclass.prototype = Object.create(Parent.prototype);
        object_1.ClassMeta.applyAllMixins(Subclass, Parent);
        // recurse into sub-subclasses
        relinkSubclasses(Subclass);
    });
}
exports.relinkSubclasses = relinkSubclasses;
function toMixin(extension) {
    if (extension instanceof Mixin)
        return extension;
    else
        return new Mixin(extension, []);
}
exports.toMixin = toMixin;
class ValueDescriptor extends Descriptor {
    constructor({ enumerable = true, configurable = true, writable = true, value }) {
        super();
        this.enumerable = enumerable;
        this.configurable = configurable;
        this.writable = writable;
        this.value = value;
    }
    define(target, key, home) {
        Object.defineProperty(target, key, {
            enumerable: this.enumerable,
            configurable: this.configurable,
            writable: this.writable,
            value: this.value
        });
    }
}
class DataBlueprint extends Blueprint {
    constructor({ enumerable = true, configurable = true, writable = true, value }) {
        super();
        this.enumerable = enumerable;
        this.configurable = configurable;
        this.value = value;
        this.writable = writable;
    }
    descriptor(target, key, classMeta) {
        let { enumerable, configurable, writable, value } = this;
        if (classMeta.hasConcatenatedProperty(key)) {
            classMeta.addConcatenatedProperty(key, value);
            value = classMeta.getConcatenatedProperty(key);
        }
        else if (classMeta.hasMergedProperty(key)) {
            classMeta.addMergedProperty(key, value);
            value = classMeta.getMergedProperty(key);
        }
        return new ValueDescriptor({ enumerable, configurable, writable, value });
    }
}
exports.DataBlueprint = DataBlueprint;
class AccessorBlueprint extends Blueprint {
    constructor({ enumerable = true, configurable = true, get, set }) {
        super();
        this.enumerable = enumerable;
        this.configurable = configurable;
        this.get = get;
        this.set = set;
    }
    descriptor(target, key, classMeta) {
        return new ValueDescriptor({
            enumerable: this.enumerable,
            configurable: this.configurable,
            get: this.get,
            set: this.set
        });
    }
}
exports.AccessorBlueprint = AccessorBlueprint;
class MethodDescriptor extends ValueDescriptor {
    define(target, key, home) {
        this.value = wrapMethod(home, key, this.value);
        super.define(target, key, home);
    }
}
class MethodBlueprint extends DataBlueprint {
    descriptor(target, key, classMeta) {
        let desc = super.descriptor(target, key, classMeta);
        return new MethodDescriptor(desc);
    }
}
function wrapMethod(home, methodName, original) {
    if (!(methodName in home))
        return maybeWrap(original);
    let superMethod = home[methodName];
    let func = function (...args) {
        if (!this)
            return original.apply(this, args);
        let lastSuper = this._super;
        this._super = superMethod;
        try {
            return original.apply(this, args);
        }
        finally {
            this._super = lastSuper;
        }
    };
    func.__wrapped = true;
    return func;
}
exports.wrapMethod = wrapMethod;
function maybeWrap(original) {
    if ('__wrapped' in original)
        return original;
    return function (...args) {
        if (!this)
            return original.apply(this, args);
        let lastSuper = this._super;
        this._super = utils_1.ROOT;
        try {
            return original.apply(this, args);
        }
        finally {
            this._super = lastSuper;
        }
    };
}
//# sourceMappingURL=data:application/json;base64,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