"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const object_reference_1 = require("@glimmer/object-reference");
const util_1 = require("@glimmer/util");
const mixin_1 = require("./mixin");
const { isArray } = Array;
const utils_1 = require("./utils");
exports.EMPTY_CACHE = function EMPTY_CACHE() { };
const CLASS_META = "df8be4c8-4e89-44e2-a8f9-550c8dacdca7";
function turbocharge(obj) {
    // function Dummy() {}
    // Dummy.prototype = obj;
    return obj;
}
exports.turbocharge = turbocharge;
class SealedMeta extends object_reference_1.Meta {
    addReferenceTypeFor(...args) {
        throw new Error("Cannot modify reference types on a sealed meta");
    }
}
class ClassMeta {
    constructor() {
        this.referenceTypes = util_1.dict();
        this.propertyMetadata = util_1.dict();
        this.concatenatedProperties = util_1.dict();
        this.hasConcatenatedProperties = false;
        this.mergedProperties = util_1.dict();
        this.hasMergedProperties = false;
        this.mixins = [];
        this.appliedMixins = [];
        this.staticMixins = [];
        this.subclasses = [];
        this.slots = [];
        this.InstanceMetaConstructor = null;
    }
    static fromParent(parent) {
        let meta = new this();
        meta.reset(parent);
        return meta;
    }
    static for(object) {
        if (CLASS_META in object)
            return object[CLASS_META];
        else if (object.constructor)
            return object.constructor[CLASS_META] || null;
        else
            return null;
    }
    init(object, attrs) {
        if (typeof attrs !== 'object' || attrs === null)
            return;
        if (this.hasConcatenatedProperties) {
            let concatProps = this.concatenatedProperties;
            for (let prop in concatProps) {
                if (prop in attrs) {
                    let concat = concatProps[prop].slice();
                    object[prop] = concat.concat(attrs[prop]);
                }
            }
        }
        if (this.hasMergedProperties) {
            let mergedProps = this.mergedProperties;
            for (let prop in mergedProps) {
                if (prop in attrs) {
                    let merged = util_1.assign({}, mergedProps[prop]);
                    object[prop] = util_1.assign(merged, attrs[prop]);
                }
            }
        }
    }
    addStaticMixin(mixin) {
        this.staticMixins.push(mixin);
    }
    addMixin(mixin) {
        this.mixins.push(mixin);
    }
    getStaticMixins() {
        return this.staticMixins;
    }
    getMixins() {
        return this.mixins;
    }
    addAppliedMixin(mixin) {
        this.appliedMixins.push(mixin);
    }
    hasAppliedMixin(mixin) {
        return this.appliedMixins.indexOf(mixin) !== -1;
    }
    getAppliedMixins() {
        return this.appliedMixins;
    }
    hasStaticMixin(mixin) {
        return this.staticMixins.indexOf(mixin) !== -1;
    }
    static applyAllMixins(Subclass, Parent) {
        Subclass[CLASS_META].getMixins().forEach(m => m.extendPrototypeOnto(Subclass, Parent));
        Subclass[CLASS_META].getStaticMixins().forEach(m => m.extendStatic(Subclass));
        Subclass[CLASS_META].seal();
    }
    addSubclass(constructor) {
        this.subclasses.push(constructor);
    }
    getSubclasses() {
        return this.subclasses;
    }
    addPropertyMetadata(property, value) {
        this.propertyMetadata[property] = value;
    }
    metadataForProperty(property) {
        return this.propertyMetadata[property];
    }
    addReferenceTypeFor(property, type) {
        this.referenceTypes[property] = type;
    }
    addSlotFor(property) {
        this.slots.push(property);
    }
    hasConcatenatedProperty(property) {
        if (!this.hasConcatenatedProperties)
            return false;
        return property in this.concatenatedProperties;
    }
    getConcatenatedProperty(property) {
        return this.concatenatedProperties[property];
    }
    getConcatenatedProperties() {
        return Object.keys(this.concatenatedProperties);
    }
    addConcatenatedProperty(property, value) {
        this.hasConcatenatedProperties = true;
        if (property in this.concatenatedProperties) {
            let val = this.concatenatedProperties[property].concat(value);
            this.concatenatedProperties[property] = val;
        }
        else {
            this.concatenatedProperties[property] = value;
        }
    }
    hasMergedProperty(property) {
        if (!this.hasMergedProperties)
            return false;
        return property in this.mergedProperties;
    }
    getMergedProperty(property) {
        return this.mergedProperties[property];
    }
    getMergedProperties() {
        return Object.keys(this.mergedProperties);
    }
    addMergedProperty(property, value) {
        this.hasMergedProperties = true;
        if (isArray(value)) {
            throw new Error(`You passed in \`${JSON.stringify(value)}\` as the value for \`foo\` but \`foo\` cannot be an Array`);
        }
        if (property in this.mergedProperties && this.mergedProperties[property] && value) {
            this.mergedProperties[property] = mergeMergedProperties(value, this.mergedProperties[property]);
        }
        else {
            value = value === null ? value : value || {};
            this.mergedProperties[property] = value;
        }
    }
    getReferenceTypes() {
        return this.referenceTypes;
    }
    getPropertyMetadata() {
        return this.propertyMetadata;
    }
    reset(parent) {
        this.referenceTypes = util_1.dict();
        this.propertyMetadata = util_1.dict();
        this.concatenatedProperties = util_1.dict();
        this.mergedProperties = util_1.dict();
        if (parent) {
            this.hasConcatenatedProperties = parent.hasConcatenatedProperties;
            for (let prop in parent.concatenatedProperties) {
                this.concatenatedProperties[prop] = parent.concatenatedProperties[prop].slice();
            }
            this.hasMergedProperties = parent.hasMergedProperties;
            for (let prop in parent.mergedProperties) {
                this.mergedProperties[prop] = util_1.assign({}, parent.mergedProperties[prop]);
            }
            util_1.assign(this.referenceTypes, parent.referenceTypes);
            util_1.assign(this.propertyMetadata, parent.propertyMetadata);
        }
    }
    reseal(obj) {
        let meta = object_reference_1.Meta.for(obj);
        let fresh = new this.InstanceMetaConstructor(obj, {});
        let referenceTypes = meta.getReferenceTypes();
        let slots = meta.getSlots();
        turbocharge(util_1.assign(referenceTypes, this.referenceTypes));
        turbocharge(util_1.assign(slots, fresh.getSlots()));
    }
    seal() {
        let referenceTypes = turbocharge(util_1.assign({}, this.referenceTypes));
        turbocharge(this.concatenatedProperties);
        turbocharge(this.mergedProperties);
        if (!this.hasMergedProperties && !this.hasConcatenatedProperties) {
            this.init = function () { };
        }
        let slots = this.slots;
        class Slots {
            constructor() {
                slots.forEach(name => {
                    this[name] = exports.EMPTY_CACHE;
                });
            }
        }
        this.InstanceMetaConstructor = class extends SealedMeta {
            constructor() {
                super(...arguments);
                this.slots = new Slots();
                this.referenceTypes = referenceTypes;
            }
            getReferenceTypes() {
                return this.referenceTypes;
            }
            referenceTypeFor(property) {
                return this.referenceTypes[property] || object_reference_1.PropertyReference;
            }
            getSlots() {
                return this.slots;
            }
        };
        turbocharge(this);
    }
}
exports.ClassMeta = ClassMeta;
function mergeMergedProperties(attrs, parent) {
    let merged = util_1.assign({}, parent);
    for (let prop in attrs) {
        if (prop in parent && typeof parent[prop] === 'function' && typeof attrs[prop] === 'function') {
            let wrapped = mixin_1.wrapMethod(parent, prop, attrs[prop]);
            merged[prop] = wrapped;
        }
        else {
            merged[prop] = attrs[prop];
        }
    }
    return merged;
}
class InstanceMeta extends ClassMeta {
    constructor() {
        super(...arguments);
        this["df8be4c8-4e89-44e2-a8f9-550c8dacdca7"] = ClassMeta.fromParent(null);
    }
    static fromParent(parent) {
        return super.fromParent(parent);
    }
    reset(parent) {
        super.reset(parent);
        if (parent)
            this[CLASS_META].reset(parent[CLASS_META]);
    }
    seal() {
        super.seal();
        this[CLASS_META].seal();
    }
}
exports.InstanceMeta = InstanceMeta;
class GlimmerObject {
    constructor(attrs) {
        this._super = utils_1.ROOT;
        this._meta = null;
        if (attrs)
            util_1.assign(this, attrs);
        this.constructor[CLASS_META].init(this, attrs);
        this._super = utils_1.ROOT;
        util_1.initializeGuid(this);
        this.init();
    }
    static extend(...extensions) {
        return mixin_1.extend(this, ...extensions);
    }
    static create(attrs) {
        return new this(attrs);
    }
    static reopen(extensions) {
        mixin_1.toMixin(extensions).extendPrototype(this);
        this[CLASS_META].seal();
        mixin_1.relinkSubclasses(this);
    }
    static reopenClass(extensions) {
        mixin_1.toMixin(extensions).extendStatic(this);
        this[CLASS_META].seal();
    }
    static metaForProperty(property) {
        let value = this[CLASS_META].metadataForProperty(property);
        if (!value)
            throw new Error(`metaForProperty() could not find a computed property with key '${property}'.`);
        return value;
    }
    static eachComputedProperty(callback) {
        let metadata = this[CLASS_META].getPropertyMetadata();
        if (!metadata)
            return;
        for (let prop in metadata) {
            callback(prop, metadata[prop]);
        }
    }
    init() { }
    get(key) {
        return this[key];
    }
    set(key, value) {
        this[key] = value;
    }
    setProperties(attrs) {
        util_1.assign(this, attrs);
    }
    destroy() { }
}
GlimmerObject["df8be4c8-4e89-44e2-a8f9-550c8dacdca7"] = InstanceMeta.fromParent(null);
GlimmerObject.isClass = true;
exports.default = GlimmerObject;
//# sourceMappingURL=data:application/json;base64,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