"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const HAS_SUPER_PATTERN = /\.(_super|call\(this|apply\(this)/;
exports.checkHasSuper = (function () {
    let sourceAvailable = (function () {
        return this;
    }).toString().indexOf('return this') > -1;
    if (sourceAvailable) {
        return function checkHasSuper(func) {
            return HAS_SUPER_PATTERN.test(func.toString());
        };
    }
    return function checkHasSuper() {
        return true;
    };
}());
function ROOT(...args) { }
exports.ROOT = ROOT;
ROOT.__hasSuper = false;
function hasSuper(func) {
    if (func.__hasSuper === undefined) {
        func.__hasSuper = exports.checkHasSuper(func);
    }
    return func.__hasSuper;
}
exports.hasSuper = hasSuper;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9saWIvdXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxNQUFNLGlCQUFpQixHQUFHLG1DQUFtQyxDQUFDO0FBRWpELFFBQUEsYUFBYSxHQUFHLENBQUM7SUFDNUIsSUFBSSxlQUFlLEdBQUcsQ0FBQztRQUNyQixNQUFNLENBQUMsSUFBSSxDQUFDO0lBQ2QsQ0FBQyxDQUFDLENBQUMsUUFBUSxFQUFFLENBQUMsT0FBTyxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBRTFDLEVBQUUsQ0FBQyxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7UUFDcEIsTUFBTSxDQUFDLHVCQUF1QixJQUFJO1lBQ2hDLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7UUFDakQsQ0FBQyxDQUFDO0lBQ0osQ0FBQztJQUVELE1BQU0sQ0FBQztRQUNMLE1BQU0sQ0FBQyxJQUFJLENBQUM7SUFDZCxDQUFDLENBQUM7QUFDSixDQUFDLEVBQUUsQ0FBQyxDQUFDO0FBRUwsY0FBcUIsR0FBRyxJQUFJLElBQUcsQ0FBQztBQUFoQyxvQkFBZ0M7QUFDMUIsSUFBSyxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7QUFFL0Isa0JBQXlCLElBQUk7SUFDM0IsRUFBRSxDQUFDLENBQUMsSUFBSSxDQUFDLFVBQVUsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDO1FBQ2xDLElBQUksQ0FBQyxVQUFVLEdBQUcscUJBQWEsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBQ0QsTUFBTSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUM7QUFDekIsQ0FBQztBQUxELDRCQUtDIn0=