import { ClassMeta } from './object';
import { Descriptor, Blueprint } from './mixin';
export interface ComputedGetCallback {
    (): any;
}
export interface LegacyComputedGetCallback {
    (key: string): any;
}
export interface ComputedSetCallback {
    (val: any): any;
}
export interface LegacyComputedSetCallback {
    (key: string, val: any): any;
}
export interface ComputedDescriptor {
    get?: ComputedGetCallback | LegacyComputedGetCallback;
    set?: ComputedSetCallback | LegacyComputedSetCallback;
}
export declare class ComputedBlueprint extends Blueprint {
    private accessor;
    private deps;
    private metadata;
    constructor(accessor: ComputedDescriptor, deps?: string[][]);
    descriptor(target: Object, key: string, classMeta: ClassMeta): Descriptor;
    property(...paths: string[]): this;
    meta(object: Object): this;
    volatile(): this;
}
export declare function computed(desc: ComputedDescriptor): ComputedBlueprint;
export declare function computed(getter: ComputedGetCallback | LegacyComputedGetCallback): ComputedBlueprint;
export declare function computed(...args: any[]): ComputedBlueprint;
export declare function observer(...args: any[]): void;
