import { ComputedReferenceBlueprint, Meta } from '@glimmer/object-reference';
import { EMPTY_CACHE } from './object';
import { Blueprint } from './mixin';
export class ComputedBlueprint extends Blueprint {
    constructor(accessor, deps = []) {
        super();
        this.metadata = {};
        this.accessor = accessor;
        this.deps = deps;
    }
    descriptor(target, key, classMeta) {
        classMeta.addReferenceTypeFor(key, ComputedReferenceBlueprint(key, this.deps));
        classMeta.addPropertyMetadata(key, this.metadata);
        classMeta.addSlotFor(key);
        return new Computed(this.accessor);
    }
    property(...paths) {
        this.deps = paths.map(d => d.split('.'));
        return this;
    }
    meta(object) {
        this.metadata = object;
        return this;
    }
    volatile() {
        return this;
    }
}
class Computed {
    constructor(accessor) {
        this["5d90f84f-908e-4a42-9749-3d0f523c262c"] = true;
        this.accessor = accessor;
    }
    define(prototype, key, home) {
        Object.defineProperty(prototype, key, wrapAccessor(home, key, this.accessor));
    }
}
function wrapAccessor(home, accessorName, _desc) {
    let superDesc = getPropertyDescriptor(home, accessorName);
    let originalGet;
    let originalSet;
    let desc = {
        enumerable: true,
        configurable: true,
    };
    if (_desc.get && _desc.get.length > 0) {
        originalGet = function () { return _desc.get.call(this, accessorName); };
    }
    else {
        originalGet = _desc.get;
    }
    if (_desc.set && _desc.set.length > 1) {
        originalSet = function (value) {
            return _desc.set.call(this, accessorName, value);
        };
    }
    else {
        originalSet = _desc.set;
    }
    let cacheGet = function () {
        if (Meta.exists(this)) {
            let slot = Meta.for(this).getSlots()[accessorName];
            if (slot !== EMPTY_CACHE)
                return slot;
        }
        return originalGet.call(this);
    };
    let cacheSet;
    if (originalSet) {
        cacheSet = function (value) {
            let meta = Meta.for(this);
            let slots = meta.getSlots();
            let ret = originalSet.call(this, value);
            if (ret !== undefined) {
                slots[accessorName] = ret;
            }
        };
    }
    else {
        cacheSet = function (value) {
            let meta = Meta.for(this);
            let slots = meta.getSlots();
            if (value !== undefined)
                slots[accessorName] = value;
        };
    }
    if (!superDesc || 'value' in superDesc) {
        desc.get = cacheGet;
        desc.set = cacheSet;
        return desc;
    }
    desc.get = function () {
        let lastSuper = this._super;
        this._super = function () {
            return superDesc.get.call(this);
        };
        try {
            return cacheGet.call(this);
        }
        finally {
            this._super = lastSuper;
        }
    };
    desc.set = function (val) {
        let lastSuper = this._super;
        this._super = function () {
            return superDesc.set.call(this, val);
        };
        try {
            return cacheSet.call(this, val);
        }
        finally {
            this._super = lastSuper;
        }
    };
    return desc;
}
function getPropertyDescriptor(subject, name) {
    let pd = Object.getOwnPropertyDescriptor(subject, name);
    let proto = Object.getPrototypeOf(subject);
    while (typeof pd === 'undefined' && proto !== null) {
        pd = Object.getOwnPropertyDescriptor(proto, name);
        proto = Object.getPrototypeOf(proto);
    }
    return pd;
}
export function computed(...args) {
    let last = args.pop();
    let deps = args;
    if (typeof last === 'function') {
        return new ComputedBlueprint({
            get: last
        }).property(...deps);
    }
    else if (typeof last === 'object') {
        return new ComputedBlueprint(last).property(...deps);
    }
    else {
        throw new TypeError("computed expects a function or an object as last argument");
    }
}
export function observer(...args) {
}
//# sourceMappingURL=data:application/json;base64,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