import { Blueprint, Descriptor } from './mixin';
import { ComputedBlueprint } from './computed';
class AliasMethodDescriptor extends Descriptor {
    constructor(name) {
        super();
        this.name = name;
    }
    define(target, key, home) {
        let name = this.name;
        Object.defineProperty(target, key, {
            enumerable: true,
            configurable: true,
            get() {
                return this[name];
            }
        });
    }
}
class AliasMethodBlueprint extends Blueprint {
    constructor(name) {
        super();
        this.name = name;
    }
    descriptor(target, key, meta) {
        return new AliasMethodDescriptor(this.name);
    }
}
export function aliasMethod(name) {
    return new AliasMethodBlueprint(name);
}
class AliasBlueprint extends ComputedBlueprint {
    constructor(name) {
        let parent = name.slice(0, -1);
        let last = name[name.length - 1];
        let get = function () {
            return name.reduce((obj, n) => obj[n], this);
        };
        let set = function (value) {
            let p = parent.reduce((obj, n) => obj[n], this);
            p[last] = value;
        };
        super({ get, set }, [name]);
        this.name = name;
    }
    descriptor(target, key, meta) {
        if (this.name[0] === key)
            throw new Error(`Setting alias '${key}' on self`);
        return super.descriptor(target, key, meta);
    }
}
export function alias(name) {
    return new AliasBlueprint(name.split('.'));
}
//# sourceMappingURL=data:application/json;base64,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