import { CLASS_META } from '@glimmer/object-reference';
import { dict, assign } from '@glimmer/util';
import { ClassMeta, InstanceMeta, turbocharge } from './object';
import { ROOT } from './utils';
const { isArray } = Array;
export const DESCRIPTOR = "5d90f84f-908e-4a42-9749-3d0f523c262c";
export const BLUEPRINT = "8d97cf5f-db9e-48d8-a6b2-7a75b7170805";
export class Descriptor {
    constructor() {
        this["5d90f84f-908e-4a42-9749-3d0f523c262c"] = true;
    }
}
export class Blueprint {
    constructor() {
        this["8d97cf5f-db9e-48d8-a6b2-7a75b7170805"] = true;
    }
}
export class Mixin {
    constructor(extensions, mixins) {
        this.extensions = null;
        this.concatenatedProperties = [];
        this.mergedProperties = [];
        this.dependencies = [];
        this.reopen(extensions);
        this.dependencies.push(...mixins);
    }
    static create(...args) {
        let extensions = args[args.length - 1];
        if (args.length === 0) {
            return new this({}, []);
        }
        else if (extensions instanceof Mixin) {
            return new this({}, args);
        }
        else {
            let deps = args.slice(0, -1).map(toMixin);
            return new this(extensions, deps);
        }
    }
    static mixins(obj) {
        if (typeof obj !== 'object' || obj === null)
            return [];
        let meta = ClassMeta.for(obj);
        if (!meta)
            return [];
        return meta.getAppliedMixins();
    }
    detect(obj) {
        if (typeof obj !== 'object' || obj === null)
            return false;
        if (obj instanceof Mixin) {
            return obj.dependencies.indexOf(this) !== -1;
        }
        let meta = ClassMeta.for(obj);
        return !!meta && meta.hasAppliedMixin(this);
    }
    reopen(extensions) {
        if (this.extensions) {
            this.dependencies.push(toMixin(this.extensions));
        }
        if (typeof extensions === 'object' && 'concatenatedProperties' in extensions) {
            let concat;
            let rawConcat = extensions.concatenatedProperties;
            if (isArray(rawConcat)) {
                concat = rawConcat.slice();
            }
            else if (rawConcat === null || rawConcat === undefined) {
                concat = [];
            }
            else {
                concat = [rawConcat];
            }
            delete extensions.concatenatedProperties;
            this.concatenatedProperties = concat;
        }
        if (typeof extensions === 'object' && 'mergedProperties' in extensions) {
            let merged;
            let rawMerged = extensions.mergedProperties;
            if (isArray(rawMerged)) {
                merged = rawMerged.slice();
            }
            else if (rawMerged === null || rawMerged === undefined) {
                merged = [];
            }
            else {
                merged = [rawMerged];
            }
            delete extensions.mergedProperties;
            this.mergedProperties = merged;
        }
        let normalized = Object.keys(extensions).reduce((obj, key) => {
            let value = extensions[key];
            switch (typeof value) {
                case 'function':
                    obj[key] = new MethodBlueprint({ value });
                    break;
                case 'object':
                    if (value && BLUEPRINT in value) {
                        obj[key] = value;
                        break;
                    }
                /* falls through */
                default:
                    obj[key] = new DataBlueprint({ value });
            }
            return obj;
        }, dict());
        this.extensions = dict();
        assign(this.extensions, turbocharge(normalized));
    }
    apply(target) {
        let meta = target[CLASS_META] = target[CLASS_META] || new ClassMeta();
        this.dependencies.forEach(m => m.apply(target));
        this.mergeProperties(target, target, meta);
        meta.addMixin(this);
        meta.seal();
        meta.reseal(target);
        return target;
    }
    extendPrototype(Original) {
        Original.prototype = Object.create(Original.prototype);
        this.dependencies.forEach(m => m.extendPrototype(Original));
        this.extendPrototypeOnto(Original, Original);
    }
    extendPrototypeOnto(Subclass, Parent) {
        this.dependencies.forEach(m => m.extendPrototypeOnto(Subclass, Parent));
        this.mergeProperties(Subclass.prototype, Parent.prototype, Subclass[CLASS_META]);
        Subclass[CLASS_META].addMixin(this);
    }
    extendStatic(Target) {
        this.dependencies.forEach(m => m.extendStatic(Target));
        this.mergeProperties(Target, Object.getPrototypeOf(Target), Target[CLASS_META][CLASS_META]);
        Target[CLASS_META].addStaticMixin(this);
    }
    mergeProperties(target, parent, meta) {
        if (meta.hasAppliedMixin(this))
            return;
        meta.addAppliedMixin(this);
        this.mergedProperties.forEach(k => meta.addMergedProperty(k, parent[k]));
        this.concatenatedProperties.forEach(k => meta.addConcatenatedProperty(k, []));
        new ValueDescriptor({ value: meta.getConcatenatedProperties() }).define(target, 'concatenatedProperties', null);
        new ValueDescriptor({ value: meta.getMergedProperties() }).define(target, 'mergedProperties', null);
        Object.keys(this.extensions).forEach(key => {
            let extension = this.extensions[key];
            let desc = extension.descriptor(target, key, meta);
            desc.define(target, key, parent);
        });
        new ValueDescriptor({ value: ROOT }).define(target, '_super', null);
    }
}
export function extend(Parent, ...extensions) {
    let Super = Parent;
    let Subclass = class extends Super {
    };
    Subclass[CLASS_META] = InstanceMeta.fromParent(Parent[CLASS_META]);
    let mixins = extensions.map(toMixin);
    Parent[CLASS_META].addSubclass(Subclass);
    mixins.forEach(m => Subclass[CLASS_META].addMixin(m));
    ClassMeta.applyAllMixins(Subclass, Parent);
    return Subclass;
}
export function relinkSubclasses(Parent) {
    Parent[CLASS_META].getSubclasses().forEach((Subclass) => {
        Subclass[CLASS_META].reset(Parent[CLASS_META]);
        Subclass.prototype = Object.create(Parent.prototype);
        ClassMeta.applyAllMixins(Subclass, Parent);
        // recurse into sub-subclasses
        relinkSubclasses(Subclass);
    });
}
export function toMixin(extension) {
    if (extension instanceof Mixin)
        return extension;
    else
        return new Mixin(extension, []);
}
class ValueDescriptor extends Descriptor {
    constructor({ enumerable = true, configurable = true, writable = true, value }) {
        super();
        this.enumerable = enumerable;
        this.configurable = configurable;
        this.writable = writable;
        this.value = value;
    }
    define(target, key, home) {
        Object.defineProperty(target, key, {
            enumerable: this.enumerable,
            configurable: this.configurable,
            writable: this.writable,
            value: this.value
        });
    }
}
export class DataBlueprint extends Blueprint {
    constructor({ enumerable = true, configurable = true, writable = true, value }) {
        super();
        this.enumerable = enumerable;
        this.configurable = configurable;
        this.value = value;
        this.writable = writable;
    }
    descriptor(target, key, classMeta) {
        let { enumerable, configurable, writable, value } = this;
        if (classMeta.hasConcatenatedProperty(key)) {
            classMeta.addConcatenatedProperty(key, value);
            value = classMeta.getConcatenatedProperty(key);
        }
        else if (classMeta.hasMergedProperty(key)) {
            classMeta.addMergedProperty(key, value);
            value = classMeta.getMergedProperty(key);
        }
        return new ValueDescriptor({ enumerable, configurable, writable, value });
    }
}
export class AccessorBlueprint extends Blueprint {
    constructor({ enumerable = true, configurable = true, get, set }) {
        super();
        this.enumerable = enumerable;
        this.configurable = configurable;
        this.get = get;
        this.set = set;
    }
    descriptor(target, key, classMeta) {
        return new ValueDescriptor({
            enumerable: this.enumerable,
            configurable: this.configurable,
            get: this.get,
            set: this.set
        });
    }
}
class MethodDescriptor extends ValueDescriptor {
    define(target, key, home) {
        this.value = wrapMethod(home, key, this.value);
        super.define(target, key, home);
    }
}
class MethodBlueprint extends DataBlueprint {
    descriptor(target, key, classMeta) {
        let desc = super.descriptor(target, key, classMeta);
        return new MethodDescriptor(desc);
    }
}
export function wrapMethod(home, methodName, original) {
    if (!(methodName in home))
        return maybeWrap(original);
    let superMethod = home[methodName];
    let func = function (...args) {
        if (!this)
            return original.apply(this, args);
        let lastSuper = this._super;
        this._super = superMethod;
        try {
            return original.apply(this, args);
        }
        finally {
            this._super = lastSuper;
        }
    };
    func.__wrapped = true;
    return func;
}
function maybeWrap(original) {
    if ('__wrapped' in original)
        return original;
    return function (...args) {
        if (!this)
            return original.apply(this, args);
        let lastSuper = this._super;
        this._super = ROOT;
        try {
            return original.apply(this, args);
        }
        finally {
            this._super = lastSuper;
        }
    };
}
//# sourceMappingURL=data:application/json;base64,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