import { Meta, PropertyReference } from '@glimmer/object-reference';
import { dict, assign, initializeGuid } from '@glimmer/util';
import { extend as extendClass, toMixin, relinkSubclasses, wrapMethod } from './mixin';
const { isArray } = Array;
import { ROOT } from './utils';
export const EMPTY_CACHE = function EMPTY_CACHE() { };
const CLASS_META = "df8be4c8-4e89-44e2-a8f9-550c8dacdca7";
export function turbocharge(obj) {
    // function Dummy() {}
    // Dummy.prototype = obj;
    return obj;
}
class SealedMeta extends Meta {
    addReferenceTypeFor(...args) {
        throw new Error("Cannot modify reference types on a sealed meta");
    }
}
export class ClassMeta {
    constructor() {
        this.referenceTypes = dict();
        this.propertyMetadata = dict();
        this.concatenatedProperties = dict();
        this.hasConcatenatedProperties = false;
        this.mergedProperties = dict();
        this.hasMergedProperties = false;
        this.mixins = [];
        this.appliedMixins = [];
        this.staticMixins = [];
        this.subclasses = [];
        this.slots = [];
        this.InstanceMetaConstructor = null;
    }
    static fromParent(parent) {
        let meta = new this();
        meta.reset(parent);
        return meta;
    }
    static for(object) {
        if (CLASS_META in object)
            return object[CLASS_META];
        else if (object.constructor)
            return object.constructor[CLASS_META] || null;
        else
            return null;
    }
    init(object, attrs) {
        if (typeof attrs !== 'object' || attrs === null)
            return;
        if (this.hasConcatenatedProperties) {
            let concatProps = this.concatenatedProperties;
            for (let prop in concatProps) {
                if (prop in attrs) {
                    let concat = concatProps[prop].slice();
                    object[prop] = concat.concat(attrs[prop]);
                }
            }
        }
        if (this.hasMergedProperties) {
            let mergedProps = this.mergedProperties;
            for (let prop in mergedProps) {
                if (prop in attrs) {
                    let merged = assign({}, mergedProps[prop]);
                    object[prop] = assign(merged, attrs[prop]);
                }
            }
        }
    }
    addStaticMixin(mixin) {
        this.staticMixins.push(mixin);
    }
    addMixin(mixin) {
        this.mixins.push(mixin);
    }
    getStaticMixins() {
        return this.staticMixins;
    }
    getMixins() {
        return this.mixins;
    }
    addAppliedMixin(mixin) {
        this.appliedMixins.push(mixin);
    }
    hasAppliedMixin(mixin) {
        return this.appliedMixins.indexOf(mixin) !== -1;
    }
    getAppliedMixins() {
        return this.appliedMixins;
    }
    hasStaticMixin(mixin) {
        return this.staticMixins.indexOf(mixin) !== -1;
    }
    static applyAllMixins(Subclass, Parent) {
        Subclass[CLASS_META].getMixins().forEach(m => m.extendPrototypeOnto(Subclass, Parent));
        Subclass[CLASS_META].getStaticMixins().forEach(m => m.extendStatic(Subclass));
        Subclass[CLASS_META].seal();
    }
    addSubclass(constructor) {
        this.subclasses.push(constructor);
    }
    getSubclasses() {
        return this.subclasses;
    }
    addPropertyMetadata(property, value) {
        this.propertyMetadata[property] = value;
    }
    metadataForProperty(property) {
        return this.propertyMetadata[property];
    }
    addReferenceTypeFor(property, type) {
        this.referenceTypes[property] = type;
    }
    addSlotFor(property) {
        this.slots.push(property);
    }
    hasConcatenatedProperty(property) {
        if (!this.hasConcatenatedProperties)
            return false;
        return property in this.concatenatedProperties;
    }
    getConcatenatedProperty(property) {
        return this.concatenatedProperties[property];
    }
    getConcatenatedProperties() {
        return Object.keys(this.concatenatedProperties);
    }
    addConcatenatedProperty(property, value) {
        this.hasConcatenatedProperties = true;
        if (property in this.concatenatedProperties) {
            let val = this.concatenatedProperties[property].concat(value);
            this.concatenatedProperties[property] = val;
        }
        else {
            this.concatenatedProperties[property] = value;
        }
    }
    hasMergedProperty(property) {
        if (!this.hasMergedProperties)
            return false;
        return property in this.mergedProperties;
    }
    getMergedProperty(property) {
        return this.mergedProperties[property];
    }
    getMergedProperties() {
        return Object.keys(this.mergedProperties);
    }
    addMergedProperty(property, value) {
        this.hasMergedProperties = true;
        if (isArray(value)) {
            throw new Error(`You passed in \`${JSON.stringify(value)}\` as the value for \`foo\` but \`foo\` cannot be an Array`);
        }
        if (property in this.mergedProperties && this.mergedProperties[property] && value) {
            this.mergedProperties[property] = mergeMergedProperties(value, this.mergedProperties[property]);
        }
        else {
            value = value === null ? value : value || {};
            this.mergedProperties[property] = value;
        }
    }
    getReferenceTypes() {
        return this.referenceTypes;
    }
    getPropertyMetadata() {
        return this.propertyMetadata;
    }
    reset(parent) {
        this.referenceTypes = dict();
        this.propertyMetadata = dict();
        this.concatenatedProperties = dict();
        this.mergedProperties = dict();
        if (parent) {
            this.hasConcatenatedProperties = parent.hasConcatenatedProperties;
            for (let prop in parent.concatenatedProperties) {
                this.concatenatedProperties[prop] = parent.concatenatedProperties[prop].slice();
            }
            this.hasMergedProperties = parent.hasMergedProperties;
            for (let prop in parent.mergedProperties) {
                this.mergedProperties[prop] = assign({}, parent.mergedProperties[prop]);
            }
            assign(this.referenceTypes, parent.referenceTypes);
            assign(this.propertyMetadata, parent.propertyMetadata);
        }
    }
    reseal(obj) {
        let meta = Meta.for(obj);
        let fresh = new this.InstanceMetaConstructor(obj, {});
        let referenceTypes = meta.getReferenceTypes();
        let slots = meta.getSlots();
        turbocharge(assign(referenceTypes, this.referenceTypes));
        turbocharge(assign(slots, fresh.getSlots()));
    }
    seal() {
        let referenceTypes = turbocharge(assign({}, this.referenceTypes));
        turbocharge(this.concatenatedProperties);
        turbocharge(this.mergedProperties);
        if (!this.hasMergedProperties && !this.hasConcatenatedProperties) {
            this.init = function () { };
        }
        let slots = this.slots;
        class Slots {
            constructor() {
                slots.forEach(name => {
                    this[name] = EMPTY_CACHE;
                });
            }
        }
        this.InstanceMetaConstructor = class extends SealedMeta {
            constructor() {
                super(...arguments);
                this.slots = new Slots();
                this.referenceTypes = referenceTypes;
            }
            getReferenceTypes() {
                return this.referenceTypes;
            }
            referenceTypeFor(property) {
                return this.referenceTypes[property] || PropertyReference;
            }
            getSlots() {
                return this.slots;
            }
        };
        turbocharge(this);
    }
}
function mergeMergedProperties(attrs, parent) {
    let merged = assign({}, parent);
    for (let prop in attrs) {
        if (prop in parent && typeof parent[prop] === 'function' && typeof attrs[prop] === 'function') {
            let wrapped = wrapMethod(parent, prop, attrs[prop]);
            merged[prop] = wrapped;
        }
        else {
            merged[prop] = attrs[prop];
        }
    }
    return merged;
}
export class InstanceMeta extends ClassMeta {
    constructor() {
        super(...arguments);
        this["df8be4c8-4e89-44e2-a8f9-550c8dacdca7"] = ClassMeta.fromParent(null);
    }
    static fromParent(parent) {
        return super.fromParent(parent);
    }
    reset(parent) {
        super.reset(parent);
        if (parent)
            this[CLASS_META].reset(parent[CLASS_META]);
    }
    seal() {
        super.seal();
        this[CLASS_META].seal();
    }
}
export default class GlimmerObject {
    constructor(attrs) {
        this._super = ROOT;
        this._meta = null;
        if (attrs)
            assign(this, attrs);
        this.constructor[CLASS_META].init(this, attrs);
        this._super = ROOT;
        initializeGuid(this);
        this.init();
    }
    static extend(...extensions) {
        return extendClass(this, ...extensions);
    }
    static create(attrs) {
        return new this(attrs);
    }
    static reopen(extensions) {
        toMixin(extensions).extendPrototype(this);
        this[CLASS_META].seal();
        relinkSubclasses(this);
    }
    static reopenClass(extensions) {
        toMixin(extensions).extendStatic(this);
        this[CLASS_META].seal();
    }
    static metaForProperty(property) {
        let value = this[CLASS_META].metadataForProperty(property);
        if (!value)
            throw new Error(`metaForProperty() could not find a computed property with key '${property}'.`);
        return value;
    }
    static eachComputedProperty(callback) {
        let metadata = this[CLASS_META].getPropertyMetadata();
        if (!metadata)
            return;
        for (let prop in metadata) {
            callback(prop, metadata[prop]);
        }
    }
    init() { }
    get(key) {
        return this[key];
    }
    set(key, value) {
        this[key] = value;
    }
    setProperties(attrs) {
        assign(this, attrs);
    }
    destroy() { }
}
GlimmerObject["df8be4c8-4e89-44e2-a8f9-550c8dacdca7"] = InstanceMeta.fromParent(null);
GlimmerObject.isClass = true;
//# sourceMappingURL=data:application/json;base64,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