const HAS_SUPER_PATTERN = /\.(_super|call\(this|apply\(this)/;
export const checkHasSuper = (function () {
    let sourceAvailable = (function () {
        return this;
    }).toString().indexOf('return this') > -1;
    if (sourceAvailable) {
        return function checkHasSuper(func) {
            return HAS_SUPER_PATTERN.test(func.toString());
        };
    }
    return function checkHasSuper() {
        return true;
    };
}());
export function ROOT(...args) { }
ROOT.__hasSuper = false;
export function hasSuper(func) {
    if (func.__hasSuper === undefined) {
        func.__hasSuper = checkHasSuper(func);
    }
    return func.__hasSuper;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9saWIvdXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsTUFBTSxpQkFBaUIsR0FBRyxtQ0FBbUMsQ0FBQztBQUU5RCxNQUFNLENBQUMsTUFBTSxhQUFhLEdBQUcsQ0FBQztJQUM1QixJQUFJLGVBQWUsR0FBRyxDQUFDO1FBQ3JCLE1BQU0sQ0FBQyxJQUFJLENBQUM7SUFDZCxDQUFDLENBQUMsQ0FBQyxRQUFRLEVBQUUsQ0FBQyxPQUFPLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFFMUMsRUFBRSxDQUFDLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztRQUNwQixNQUFNLENBQUMsdUJBQXVCLElBQUk7WUFDaEMsTUFBTSxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLENBQUMsQ0FBQztRQUNqRCxDQUFDLENBQUM7SUFDSixDQUFDO0lBRUQsTUFBTSxDQUFDO1FBQ0wsTUFBTSxDQUFDLElBQUksQ0FBQztJQUNkLENBQUMsQ0FBQztBQUNKLENBQUMsRUFBRSxDQUFDLENBQUM7QUFFTCxNQUFNLGVBQWUsR0FBRyxJQUFJLElBQUcsQ0FBQztBQUMxQixJQUFLLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztBQUUvQixNQUFNLG1CQUFtQixJQUFJO0lBQzNCLEVBQUUsQ0FBQyxDQUFDLElBQUksQ0FBQyxVQUFVLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQztRQUNsQyxJQUFJLENBQUMsVUFBVSxHQUFHLGFBQWEsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBQ0QsTUFBTSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUM7QUFDekIsQ0FBQyJ9