import { ListNode, Opaque, Option } from '@glimmer/util';
import { VersionedPathReference as PathReference, RevisionTag } from './validators';
export interface IterationItem<T, U> {
    key: string;
    value: T;
    memo: U;
}
export interface AbstractIterator<T, U, V extends IterationItem<T, U>> {
    isEmpty(): boolean;
    next(): V;
}
export interface AbstractIterable<T, U, ItemType extends IterationItem<T, U>, ValueReferenceType extends PathReference<T>, MemoReferenceType extends PathReference<U>> {
    tag: RevisionTag;
    iterate(): AbstractIterator<T, U, ItemType>;
    valueReferenceFor(item: ItemType): ValueReferenceType;
    updateValueReference(reference: ValueReferenceType, item: ItemType): void;
    memoReferenceFor(item: ItemType): MemoReferenceType;
    updateMemoReference(reference: MemoReferenceType, item: ItemType): void;
}
export declare type Iterator<T, U> = AbstractIterator<T, U, IterationItem<T, U>>;
export declare type Iterable<T, U> = AbstractIterable<T, U, IterationItem<T, U>, PathReference<T>, PathReference<U>>;
export declare type OpaqueIterationItem = IterationItem<Opaque, Opaque>;
export declare type OpaqueIterator = AbstractIterator<Opaque, Opaque, OpaqueIterationItem>;
export declare type OpaquePathReference = PathReference<Opaque>;
export declare type OpaqueIterable = AbstractIterable<Opaque, Opaque, OpaqueIterationItem, OpaquePathReference, OpaquePathReference>;
export declare type OpaquePathReferenceIterationItem = IterationItem<OpaquePathReference, OpaquePathReference>;
export declare class ListItem extends ListNode<OpaquePathReference> implements OpaqueIterationItem {
    key: string;
    memo: OpaquePathReference;
    retained: boolean;
    seen: boolean;
    private iterable;
    constructor(iterable: OpaqueIterable, result: OpaqueIterationItem);
    update(item: OpaqueIterationItem): void;
    shouldRemove(): boolean;
    reset(): void;
}
export declare class IterationArtifacts {
    tag: RevisionTag;
    private iterable;
    private iterator;
    private map;
    private list;
    constructor(iterable: OpaqueIterable);
    isEmpty(): boolean;
    iterate(): OpaqueIterator;
    has(key: string): boolean;
    get(key: string): ListItem;
    wasSeen(key: string): boolean;
    append(item: OpaqueIterationItem): ListItem;
    insertBefore(item: OpaqueIterationItem, reference: Option<ListItem>): ListItem;
    move(item: ListItem, reference: Option<ListItem>): void;
    remove(item: ListItem): void;
    nextNode(item: ListItem): ListItem;
    head(): Option<ListItem>;
}
export declare class ReferenceIterator {
    artifacts: IterationArtifacts;
    private iterator;
    constructor(iterable: OpaqueIterable);
    next(): Option<ListItem>;
}
export interface IteratorSynchronizerDelegate {
    retain(key: string, item: PathReference<Opaque>, memo: PathReference<Opaque>): void;
    insert(key: string, item: PathReference<Opaque>, memo: PathReference<Opaque>, before: Option<string>): void;
    move(key: string, item: PathReference<Opaque>, memo: PathReference<Opaque>, before: Option<string>): void;
    delete(key: string): void;
    done(): void;
}
export interface IteratorSynchronizerOptions {
    target: IteratorSynchronizerDelegate;
    artifacts: IterationArtifacts;
}
export declare class IteratorSynchronizer {
    private target;
    private iterator;
    private current;
    private artifacts;
    constructor({target, artifacts}: IteratorSynchronizerOptions);
    sync(): void;
    private advanceToKey(key);
    private nextAppend();
    private nextRetain(item);
    private nextMove(item);
    private nextInsert(item);
    private startPrune();
    private nextPrune();
    private nextDone();
}
