"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class Cursor {
    constructor(element, nextSibling) {
        this.element = element;
        this.nextSibling = nextSibling;
    }
}
exports.Cursor = Cursor;
class RealDOMBounds {
    constructor(bounds) {
        this.bounds = bounds;
    }
    parentElement() { return this.bounds.parentElement(); }
    firstNode() { return this.bounds.firstNode(); }
    lastNode() { return this.bounds.lastNode(); }
}
exports.RealDOMBounds = RealDOMBounds;
class ConcreteBounds {
    constructor(parentNode, first, last) {
        this.parentNode = parentNode;
        this.first = first;
        this.last = last;
    }
    parentElement() { return this.parentNode; }
    firstNode() { return this.first; }
    lastNode() { return this.last; }
}
exports.ConcreteBounds = ConcreteBounds;
class SingleNodeBounds {
    constructor(parentNode, node) {
        this.parentNode = parentNode;
        this.node = node;
    }
    parentElement() { return this.parentNode; }
    firstNode() { return this.node; }
    lastNode() { return this.node; }
}
exports.SingleNodeBounds = SingleNodeBounds;
function bounds(parent, first, last) {
    return new ConcreteBounds(parent, first, last);
}
exports.bounds = bounds;
function single(parent, node) {
    return new SingleNodeBounds(parent, node);
}
exports.single = single;
function move(bounds, reference) {
    let parent = bounds.parentElement();
    let first = bounds.firstNode();
    let last = bounds.lastNode();
    let node = first;
    while (node) {
        let next = node.nextSibling;
        parent.insertBefore(node, reference);
        if (node === last)
            return next;
        node = next;
    }
    return null;
}
exports.move = move;
function clear(bounds) {
    let parent = bounds.parentElement();
    let first = bounds.firstNode();
    let last = bounds.lastNode();
    let node = first;
    while (node) {
        let next = node.nextSibling;
        parent.removeChild(node);
        if (node === last)
            return next;
        node = next;
    }
    return null;
}
exports.clear = clear;
//# sourceMappingURL=data:application/json;base64,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