"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const bounds_1 = require("../bounds");
const helper_1 = require("../dom/helper");
let innerHTMLWrapper = {
    colgroup: { depth: 2, before: '<table><colgroup>', after: '</colgroup></table>' },
    table: { depth: 1, before: '<table>', after: '</table>' },
    tbody: { depth: 2, before: '<table><tbody>', after: '</tbody></table>' },
    tfoot: { depth: 2, before: '<table><tfoot>', after: '</tfoot></table>' },
    thead: { depth: 2, before: '<table><thead>', after: '</thead></table>' },
    tr: { depth: 3, before: '<table><tbody><tr>', after: '</tr></tbody></table>' }
};
// Patch:    innerHTML Fix
// Browsers: IE9
// Reason:   IE9 don't allow us to set innerHTML on col, colgroup, frameset,
//           html, style, table, tbody, tfoot, thead, title, tr.
// Fix:      Wrap the innerHTML we are about to set in its parents, apply the
//           wrapped innerHTML on a div, then move the unwrapped nodes into the
//           target position.
function domChanges(document, DOMChangesClass) {
    if (!document)
        return DOMChangesClass;
    if (!shouldApplyFix(document)) {
        return DOMChangesClass;
    }
    let div = document.createElement('div');
    return class DOMChangesWithInnerHTMLFix extends DOMChangesClass {
        insertHTMLBefore(parent, nextSibling, html) {
            if (html === null || html === '') {
                return super.insertHTMLBefore(parent, nextSibling, html);
            }
            let parentTag = parent.tagName.toLowerCase();
            let wrapper = innerHTMLWrapper[parentTag];
            if (wrapper === undefined) {
                return super.insertHTMLBefore(parent, nextSibling, html);
            }
            return fixInnerHTML(parent, wrapper, div, html, nextSibling);
        }
    };
}
exports.domChanges = domChanges;
function treeConstruction(document, DOMTreeConstructionClass) {
    if (!document)
        return DOMTreeConstructionClass;
    if (!shouldApplyFix(document)) {
        return DOMTreeConstructionClass;
    }
    let div = document.createElement('div');
    return class DOMTreeConstructionWithInnerHTMLFix extends DOMTreeConstructionClass {
        insertHTMLBefore(parent, html, reference) {
            if (html === null || html === '') {
                return super.insertHTMLBefore(parent, html, reference);
            }
            let parentTag = parent.tagName.toLowerCase();
            let wrapper = innerHTMLWrapper[parentTag];
            if (wrapper === undefined) {
                return super.insertHTMLBefore(parent, html, reference);
            }
            return fixInnerHTML(parent, wrapper, div, html, reference);
        }
    };
}
exports.treeConstruction = treeConstruction;
function fixInnerHTML(parent, wrapper, div, html, reference) {
    let wrappedHtml = wrapper.before + html + wrapper.after;
    div.innerHTML = wrappedHtml;
    let parentNode = div;
    for (let i = 0; i < wrapper.depth; i++) {
        parentNode = parentNode.childNodes[0];
    }
    let [first, last] = helper_1.moveNodesBefore(parentNode, parent, reference);
    return new bounds_1.ConcreteBounds(parent, first, last);
}
function shouldApplyFix(document) {
    let table = document.createElement('table');
    try {
        table.innerHTML = '<tbody></tbody>';
    }
    catch (e) {
    }
    finally {
        if (table.childNodes.length !== 0) {
            // It worked as expected, no fix required
            return false;
        }
    }
    return true;
}
//# sourceMappingURL=data:application/json;base64,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