"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const positional_args_1 = require("./positional-args");
exports.COMPILED_EMPTY_POSITIONAL_ARGS = positional_args_1.COMPILED_EMPTY_POSITIONAL_ARGS;
exports.CompiledPositionalArgs = positional_args_1.CompiledPositionalArgs;
exports.EvaluatedPositionalArgs = positional_args_1.EvaluatedPositionalArgs;
const named_args_1 = require("./named-args");
exports.COMPILED_EMPTY_NAMED_ARGS = named_args_1.COMPILED_EMPTY_NAMED_ARGS;
exports.CompiledNamedArgs = named_args_1.CompiledNamedArgs;
exports.EvaluatedNamedArgs = named_args_1.EvaluatedNamedArgs;
const reference_1 = require("@glimmer/reference");
exports.EMPTY_BLOCKS = {
    default: null,
    inverse: null
};
class CompiledArgs {
    constructor(positional, named, blocks) {
        this.positional = positional;
        this.named = named;
        this.blocks = blocks;
        this.type = "compiled-args";
    }
    static create(positional, named, blocks) {
        if (positional === positional_args_1.COMPILED_EMPTY_POSITIONAL_ARGS && named === named_args_1.COMPILED_EMPTY_NAMED_ARGS && blocks === exports.EMPTY_BLOCKS) {
            return this.empty();
        }
        else {
            return new this(positional, named, blocks);
        }
    }
    static empty() {
        return exports.COMPILED_EMPTY_ARGS;
    }
    evaluate(vm) {
        let { positional, named, blocks } = this;
        return EvaluatedArgs.create(positional.evaluate(vm), named.evaluate(vm), blocks);
    }
}
exports.CompiledArgs = CompiledArgs;
exports.COMPILED_EMPTY_ARGS = new (class extends CompiledArgs {
    constructor() {
        super(positional_args_1.COMPILED_EMPTY_POSITIONAL_ARGS, named_args_1.COMPILED_EMPTY_NAMED_ARGS, exports.EMPTY_BLOCKS);
    }
    evaluate(_vm) {
        return EMPTY_EVALUATED_ARGS;
    }
});
class EvaluatedArgs {
    constructor(positional, named, blocks) {
        this.positional = positional;
        this.named = named;
        this.blocks = blocks;
        this.tag = reference_1.combineTagged([positional, named]);
    }
    static empty() {
        return EMPTY_EVALUATED_ARGS;
    }
    static create(positional, named, blocks) {
        return new this(positional, named, blocks);
    }
    static positional(values, blocks = exports.EMPTY_BLOCKS) {
        return new this(positional_args_1.EvaluatedPositionalArgs.create(values), named_args_1.EVALUATED_EMPTY_NAMED_ARGS, blocks);
    }
    static named(map, blocks = exports.EMPTY_BLOCKS) {
        return new this(positional_args_1.EVALUATED_EMPTY_POSITIONAL_ARGS, named_args_1.EvaluatedNamedArgs.create(map), blocks);
    }
}
exports.EvaluatedArgs = EvaluatedArgs;
const EMPTY_EVALUATED_ARGS = new EvaluatedArgs(positional_args_1.EVALUATED_EMPTY_POSITIONAL_ARGS, named_args_1.EVALUATED_EMPTY_NAMED_ARGS, exports.EMPTY_BLOCKS);
//# sourceMappingURL=data:application/json;base64,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