"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const expressions_1 = require("../expressions");
class CompiledFunctionExpression extends expressions_1.CompiledExpression {
    constructor(func, symbolTable) {
        super();
        this.func = func;
        this.symbolTable = symbolTable;
        this.type = "function";
        this.func = func;
    }
    evaluate(vm) {
        let { func, symbolTable } = this;
        return func(vm, symbolTable);
    }
    toJSON() {
        let { func } = this;
        if (func.name) {
            return `\`${func.name}(...)\``;
        }
        else {
            return "`func(...)`";
        }
    }
}
exports.CompiledFunctionExpression = CompiledFunctionExpression;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZnVuY3Rpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9saWIvY29tcGlsZWQvZXhwcmVzc2lvbnMvZnVuY3Rpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFDQSxnREFBb0Q7QUFNcEQsZ0NBQTJDLFNBQVEsZ0NBQXFCO0lBR3RFLFlBQW9CLElBQTJCLEVBQVUsV0FBd0I7UUFDL0UsS0FBSyxFQUFFLENBQUM7UUFEVSxTQUFJLEdBQUosSUFBSSxDQUF1QjtRQUFVLGdCQUFXLEdBQVgsV0FBVyxDQUFhO1FBRjFFLFNBQUksR0FBRyxVQUFVLENBQUM7UUFJdkIsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLENBQUM7SUFDbkIsQ0FBQztJQUVELFFBQVEsQ0FBQyxFQUFNO1FBQ2IsSUFBSSxFQUFFLElBQUksRUFBRSxXQUFXLEVBQUUsR0FBRyxJQUFJLENBQUM7UUFDakMsTUFBTSxDQUFDLElBQUksQ0FBQyxFQUFFLEVBQUUsV0FBVyxDQUFDLENBQUM7SUFDL0IsQ0FBQztJQUVELE1BQU07UUFDSixJQUFJLEVBQUUsSUFBSSxFQUFFLEdBQUcsSUFBSSxDQUFDO1FBRXBCLEVBQUUsQ0FBQyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO1lBQ2QsTUFBTSxDQUFDLEtBQUssSUFBSSxDQUFDLElBQUksU0FBUyxDQUFDO1FBQ2pDLENBQUM7UUFBQyxJQUFJLENBQUMsQ0FBQztZQUNOLE1BQU0sQ0FBQyxhQUFhLENBQUM7UUFDdkIsQ0FBQztJQUNILENBQUM7Q0FDRjtBQXRCRCxnRUFzQkMifQ==