"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const expressions_1 = require("../expressions");
const references_1 = require("../../references");
class CompiledHasBlock extends expressions_1.CompiledExpression {
    constructor(inner) {
        super();
        this.inner = inner;
        this.type = "has-block";
    }
    evaluate(vm) {
        let block = this.inner.evaluate(vm);
        return references_1.PrimitiveReference.create(!!block);
    }
    toJSON() {
        return `has-block(${this.inner.toJSON()})`;
    }
}
exports.default = CompiledHasBlock;
class CompiledHasBlockParams extends expressions_1.CompiledExpression {
    constructor(inner) {
        super();
        this.inner = inner;
        this.type = "has-block-params";
    }
    evaluate(vm) {
        let block = this.inner.evaluate(vm);
        let hasLocals = block && block.symbolTable.getSymbols().locals;
        return references_1.PrimitiveReference.create(!!hasLocals);
    }
    toJSON() {
        return `has-block-params(${this.inner.toJSON()})`;
    }
}
exports.CompiledHasBlockParams = CompiledHasBlockParams;
class CompiledGetBlockBySymbol {
    constructor(symbol, debug) {
        this.symbol = symbol;
        this.debug = debug;
    }
    evaluate(vm) {
        return vm.scope().getBlock(this.symbol);
    }
    toJSON() {
        return `get-block($${this.symbol}(${this.debug}))`;
    }
}
exports.CompiledGetBlockBySymbol = CompiledGetBlockBySymbol;
class CompiledInPartialGetBlock {
    constructor(symbol, name) {
        this.symbol = symbol;
        this.name = name;
    }
    evaluate(vm) {
        let { symbol, name } = this;
        let args = vm.scope().getPartialArgs(symbol);
        return args.blocks[name];
    }
    toJSON() {
        return `get-block($${this.symbol}($ARGS).${this.name}))`;
    }
}
exports.CompiledInPartialGetBlock = CompiledInPartialGetBlock;
//# sourceMappingURL=data:application/json;base64,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