import { Opaque } from '@glimmer/util';
import { CompiledExpression } from '../expressions';
import VM from '../../vm/append';
import { PathReference } from '@glimmer/reference';
export default class CompiledLookup extends CompiledExpression<Opaque> {
    private base;
    private path;
    type: string;
    static create(base: CompiledExpression<Opaque>, path: string[]): CompiledExpression<Opaque>;
    private constructor(base, path);
    evaluate(vm: VM): PathReference<Opaque>;
    toJSON(): string;
}
export declare class CompiledSelf extends CompiledExpression<Opaque> {
    evaluate(vm: VM): PathReference<Opaque>;
    toJSON(): string;
}
export declare class CompiledSymbol extends CompiledExpression<Opaque> {
    private symbol;
    private debug;
    constructor(symbol: number, debug: string);
    evaluate(vm: VM): PathReference<Opaque>;
    toJSON(): string;
}
export declare class CompiledInPartialName extends CompiledExpression<Opaque> {
    private symbol;
    private name;
    constructor(symbol: number, name: string);
    evaluate(vm: VM): PathReference<Opaque>;
    toJSON(): string;
}
