"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const expressions_1 = require("../expressions");
const reference_1 = require("@glimmer/reference");
class CompiledLookup extends expressions_1.CompiledExpression {
    constructor(base, path) {
        super();
        this.base = base;
        this.path = path;
        this.type = "lookup";
    }
    static create(base, path) {
        if (path.length === 0) {
            return base;
        }
        else {
            return new this(base, path);
        }
    }
    evaluate(vm) {
        let { base, path } = this;
        return reference_1.referenceFromParts(base.evaluate(vm), path);
    }
    toJSON() {
        return `${this.base.toJSON()}.${this.path.join('.')}`;
    }
}
exports.default = CompiledLookup;
class CompiledSelf extends expressions_1.CompiledExpression {
    evaluate(vm) {
        return vm.getSelf();
    }
    toJSON() {
        return 'self';
    }
}
exports.CompiledSelf = CompiledSelf;
class CompiledSymbol extends expressions_1.CompiledExpression {
    constructor(symbol, debug) {
        super();
        this.symbol = symbol;
        this.debug = debug;
    }
    evaluate(vm) {
        return vm.referenceForSymbol(this.symbol);
    }
    toJSON() {
        return `$${this.symbol}(${this.debug})`;
    }
}
exports.CompiledSymbol = CompiledSymbol;
class CompiledInPartialName extends expressions_1.CompiledExpression {
    constructor(symbol, name) {
        super();
        this.symbol = symbol;
        this.name = name;
    }
    evaluate(vm) {
        let { symbol, name } = this;
        let args = vm.scope().getPartialArgs(symbol);
        return args.named.get(name);
    }
    toJSON() {
        return `$${this.symbol}($ARGS).${this.name}`;
    }
}
exports.CompiledInPartialName = CompiledInPartialName;
//# sourceMappingURL=data:application/json;base64,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