"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const references_1 = require("../../references");
const utils_1 = require("../../utils");
const reference_1 = require("@glimmer/reference");
class CompiledPositionalArgs {
    constructor(values) {
        this.values = values;
        this.length = values.length;
    }
    static create(values) {
        if (values.length) {
            return new this(values);
        }
        else {
            return exports.COMPILED_EMPTY_POSITIONAL_ARGS;
        }
    }
    static empty() {
        return exports.COMPILED_EMPTY_POSITIONAL_ARGS;
    }
    evaluate(vm) {
        let { values, length } = this;
        let references = new Array(length);
        for (let i = 0; i < length; i++) {
            references[i] = values[i].evaluate(vm);
        }
        return EvaluatedPositionalArgs.create(references);
    }
    toJSON() {
        return `[${this.values.map(value => value.toJSON()).join(", ")}]`;
    }
}
exports.CompiledPositionalArgs = CompiledPositionalArgs;
exports.COMPILED_EMPTY_POSITIONAL_ARGS = new (class extends CompiledPositionalArgs {
    constructor() {
        super(utils_1.EMPTY_ARRAY);
    }
    evaluate(_vm) {
        return exports.EVALUATED_EMPTY_POSITIONAL_ARGS;
    }
    toJSON() {
        return `<EMPTY>`;
    }
});
class EvaluatedPositionalArgs {
    constructor(values) {
        this.values = values;
        this.tag = reference_1.combineTagged(values);
        this.length = values.length;
    }
    static create(values) {
        return new this(values);
    }
    static empty() {
        return exports.EVALUATED_EMPTY_POSITIONAL_ARGS;
    }
    at(index) {
        let { values, length } = this;
        return (index < length) ? values[index] : references_1.UNDEFINED_REFERENCE;
    }
    value() {
        let { values, length } = this;
        let ret = new Array(length);
        for (let i = 0; i < length; i++) {
            ret[i] = values[i].value();
        }
        return ret;
    }
}
exports.EvaluatedPositionalArgs = EvaluatedPositionalArgs;
exports.EVALUATED_EMPTY_POSITIONAL_ARGS = new (class extends EvaluatedPositionalArgs {
    constructor() {
        super(utils_1.EMPTY_ARRAY);
    }
    at() {
        return references_1.UNDEFINED_REFERENCE;
    }
    value() {
        return this.values;
    }
});
//# sourceMappingURL=data:application/json;base64,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