"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const expressions_1 = require("../expressions");
const references_1 = require("../../references");
class CompiledValue extends expressions_1.CompiledExpression {
    constructor(value) {
        super();
        this.type = "value";
        this.reference = references_1.PrimitiveReference.create(value);
    }
    evaluate(_vm) {
        return this.reference;
    }
    toJSON() {
        return JSON.stringify(this.reference.value());
    }
}
exports.default = CompiledValue;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmFsdWUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9saWIvY29tcGlsZWQvZXhwcmVzc2lvbnMvdmFsdWUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFDQSxnREFBb0Q7QUFDcEQsaURBQWlFO0FBRWpFLG1CQUF3RCxTQUFRLGdDQUFxQjtJQUluRixZQUFZLEtBQVE7UUFDbEIsS0FBSyxFQUFFLENBQUM7UUFKSCxTQUFJLEdBQUcsT0FBTyxDQUFDO1FBS3BCLElBQUksQ0FBQyxTQUFTLEdBQUcsK0JBQWtCLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFFRCxRQUFRLENBQUMsR0FBTztRQUNkLE1BQU0sQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQ3hCLENBQUM7SUFFRCxNQUFNO1FBQ0osTUFBTSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDO0lBQ2hELENBQUM7Q0FDRjtBQWhCRCxnQ0FnQkMifQ==