"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const opcodes_1 = require("../../opcodes");
opcodes_1.APPEND_OPCODES.add(20 /* OpenBlock */, (vm, { op1: _getBlock, op2: _args }) => {
    let inner = vm.constants.getOther(_getBlock);
    let rawArgs = vm.constants.getExpression(_args);
    let args = null;
    let block = inner.evaluate(vm);
    if (block) {
        args = rawArgs.evaluate(vm);
    }
    // FIXME: can we avoid doing this when we don't have a block?
    vm.pushCallerScope();
    if (block) {
        vm.invokeBlock(block, args || null);
    }
});
opcodes_1.APPEND_OPCODES.add(21 /* CloseBlock */, vm => vm.popScope());
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmxvY2tzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vbGliL2NvbXBpbGVkL29wY29kZXMvYmxvY2tzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBRUEsMkNBQWlFO0FBR2pFLHdCQUFjLENBQUMsR0FBRyxxQkFBZSxDQUFDLEVBQUUsRUFBRSxFQUFFLEdBQUcsRUFBRSxTQUFTLEVBQUUsR0FBRyxFQUFFLEtBQUssRUFBRTtJQUNsRSxJQUFJLEtBQUssR0FBRyxFQUFFLENBQUMsU0FBUyxDQUFDLFFBQVEsQ0FBbUIsU0FBUyxDQUFDLENBQUM7SUFDL0QsSUFBSSxPQUFPLEdBQUcsRUFBRSxDQUFDLFNBQVMsQ0FBQyxhQUFhLENBQWUsS0FBSyxDQUFDLENBQUM7SUFDOUQsSUFBSSxJQUFJLEdBQTBCLElBQUksQ0FBQztJQUV2QyxJQUFJLEtBQUssR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEVBQUUsQ0FBQyxDQUFDO0lBRS9CLEVBQUUsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7UUFDVixJQUFJLEdBQUcsT0FBTyxDQUFDLFFBQVEsQ0FBQyxFQUFFLENBQUMsQ0FBQztJQUM5QixDQUFDO0lBRUQsNkRBQTZEO0lBQzdELEVBQUUsQ0FBQyxlQUFlLEVBQUUsQ0FBQztJQUVyQixFQUFFLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO1FBQ1YsRUFBRSxDQUFDLFdBQVcsQ0FBQyxLQUFLLEVBQUUsSUFBSSxJQUFJLElBQUksQ0FBQyxDQUFDO0lBQ3RDLENBQUM7QUFDSCxDQUFDLENBQUMsQ0FBQztBQUVILHdCQUFjLENBQUMsR0FBRyxzQkFBZ0IsRUFBRSxJQUFJLEVBQUUsQ0FBQyxRQUFRLEVBQUUsQ0FBQyxDQUFDIn0=