import { OpcodeJSON, UpdatingOpcode } from '../../opcodes';
import { Component, ComponentManager } from '../../component/interfaces';
import { UpdatingVM } from '../../vm';
import { EvaluatedArgs } from '../../compiled/expressions/args';
import { DynamicScope } from '../../environment';
import Bounds from '../../bounds';
import { RevisionTag } from '@glimmer/reference';
export declare class UpdateComponentOpcode extends UpdatingOpcode {
    private name;
    private component;
    private manager;
    private args;
    private dynamicScope;
    type: string;
    constructor(name: string, component: Component, manager: ComponentManager<Component>, args: EvaluatedArgs, dynamicScope: DynamicScope);
    evaluate(_vm: UpdatingVM): void;
    toJSON(): OpcodeJSON;
}
export declare class DidUpdateLayoutOpcode extends UpdatingOpcode {
    private manager;
    private component;
    private bounds;
    type: string;
    tag: RevisionTag;
    constructor(manager: ComponentManager<Component>, component: Component, bounds: Bounds);
    evaluate(vm: UpdatingVM): void;
}
