"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const opcodes_1 = require("../../opcodes");
const vm_1 = require("./vm");
const args_1 = require("../../compiled/expressions/args");
const reference_1 = require("@glimmer/reference");
const opcodes_2 = require("../../opcodes");
opcodes_2.APPEND_OPCODES.add(22 /* PutDynamicComponent */, vm => {
    let reference = vm.frame.getOperand();
    let cache = reference_1.isConst(reference) ? undefined : new reference_1.ReferenceCache(reference);
    let definition = cache ? cache.peek() : reference.value();
    vm.frame.setImmediate(definition);
    if (cache) {
        vm.updateWith(new vm_1.Assert(cache));
    }
});
opcodes_2.APPEND_OPCODES.add(23 /* PutComponent */, (vm, { op1: _component }) => {
    let definition = vm.constants.getOther(_component);
    vm.frame.setImmediate(definition);
});
opcodes_2.APPEND_OPCODES.add(24 /* OpenComponent */, (vm, { op1: _args, op2: _shadow }) => {
    let rawArgs = vm.constants.getExpression(_args);
    let shadow = vm.constants.getBlock(_shadow);
    let definition = vm.frame.getImmediate();
    let dynamicScope = vm.pushDynamicScope();
    let callerScope = vm.scope();
    let manager = definition.manager;
    let args = manager.prepareArgs(definition, rawArgs.evaluate(vm), dynamicScope);
    let hasDefaultBlock = !!args.blocks.default; // TODO Cleanup?
    let component = manager.create(vm.env, definition, args, dynamicScope, vm.getSelf(), hasDefaultBlock);
    let destructor = manager.getDestructor(component);
    if (destructor)
        vm.newDestroyable(destructor);
    let layout = manager.layoutFor(definition, component, vm.env);
    let selfRef = manager.getSelf(component);
    vm.beginCacheGroup();
    vm.stack().pushSimpleBlock();
    vm.pushRootScope(selfRef, layout.symbols);
    vm.invokeLayout(args, layout, callerScope, component, manager, shadow);
    vm.updateWith(new UpdateComponentOpcode(definition.name, component, manager, args, dynamicScope));
});
// export class DidCreateElementOpcode extends Opcode {
//   public type = "did-create-element";
//   evaluate(vm: VM) {
//     let manager = vm.frame.getManager();
//     let component = vm.frame.getComponent();
//     let action = 'DidCreateElementOpcode#evaluate';
//     manager.didCreateElement(component, vm.stack().expectConstructing(action), vm.stack().expectOperations(action));
//   }
//   toJSON(): OpcodeJSON {
//     return {
//       guid: this._guid,
//       type: this.type,
//       args: ["$ARGS"]
//     };
//   }
// }
opcodes_2.APPEND_OPCODES.add(25 /* DidCreateElement */, vm => {
    let manager = vm.frame.getManager();
    let component = vm.frame.getComponent();
    let action = 'DidCreateElementOpcode#evaluate';
    manager.didCreateElement(component, vm.stack().expectConstructing(action), vm.stack().expectOperations(action));
});
// export class ShadowAttributesOpcode extends Opcode {
//   public type = "shadow-attributes";
//   evaluate(vm: VM) {
//     let shadow = vm.frame.getShadow();
//     vm.pushCallerScope();
//     if (!shadow) return;
//     vm.invokeBlock(shadow, EvaluatedArgs.empty());
//   }
//   toJSON(): OpcodeJSON {
//     return {
//       guid: this._guid,
//       type: this.type,
//       args: ["$ARGS"]
//     };
//   }
// }
// Slow path for non-specialized component invocations. Uses an internal
// named lookup on the args.
opcodes_2.APPEND_OPCODES.add(26 /* ShadowAttributes */, vm => {
    let shadow = vm.frame.getShadow();
    vm.pushCallerScope();
    if (!shadow)
        return;
    vm.invokeBlock(shadow, args_1.EvaluatedArgs.empty());
});
// export class DidRenderLayoutOpcode extends Opcode {
//   public type = "did-render-layout";
//   evaluate(vm: VM) {
//     let manager = vm.frame.getManager();
//     let component = vm.frame.getComponent();
//     let bounds = vm.stack().popBlock();
//     manager.didRenderLayout(component, bounds);
//     vm.env.didCreate(component, manager);
//     vm.updateWith(new DidUpdateLayoutOpcode(manager, component, bounds));
//   }
// }
opcodes_2.APPEND_OPCODES.add(27 /* DidRenderLayout */, vm => {
    let manager = vm.frame.getManager();
    let component = vm.frame.getComponent();
    let bounds = vm.stack().popBlock();
    manager.didRenderLayout(component, bounds);
    vm.env.didCreate(component, manager);
    vm.updateWith(new DidUpdateLayoutOpcode(manager, component, bounds));
});
// export class CloseComponentOpcode extends Opcode {
//   public type = "close-component";
//   evaluate(vm: VM) {
//     vm.popScope();
//     vm.popDynamicScope();
//     vm.commitCacheGroup();
//   }
// }
opcodes_2.APPEND_OPCODES.add(28 /* CloseComponent */, vm => {
    vm.popScope();
    vm.popDynamicScope();
    vm.commitCacheGroup();
});
class UpdateComponentOpcode extends opcodes_1.UpdatingOpcode {
    constructor(name, component, manager, args, dynamicScope) {
        super();
        this.name = name;
        this.component = component;
        this.manager = manager;
        this.args = args;
        this.dynamicScope = dynamicScope;
        this.type = "update-component";
        let componentTag = manager.getTag(component);
        if (componentTag) {
            this.tag = reference_1.combine([args.tag, componentTag]);
        }
        else {
            this.tag = args.tag;
        }
    }
    evaluate(_vm) {
        let { component, manager, args, dynamicScope } = this;
        manager.update(component, args, dynamicScope);
    }
    toJSON() {
        return {
            guid: this._guid,
            type: this.type,
            args: [JSON.stringify(this.name)]
        };
    }
}
exports.UpdateComponentOpcode = UpdateComponentOpcode;
class DidUpdateLayoutOpcode extends opcodes_1.UpdatingOpcode {
    constructor(manager, component, bounds) {
        super();
        this.manager = manager;
        this.component = component;
        this.bounds = bounds;
        this.type = "did-update-layout";
        this.tag = reference_1.CONSTANT_TAG;
    }
    evaluate(vm) {
        let { manager, component, bounds } = this;
        manager.didUpdateLayout(component, bounds);
        vm.env.didUpdate(component, manager);
    }
}
exports.DidUpdateLayoutOpcode = DidUpdateLayoutOpcode;
//# sourceMappingURL=data:application/json;base64,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