"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const args_1 = require("../expressions/args");
const util_1 = require("@glimmer/util");
const reference_1 = require("@glimmer/reference");
const opcodes_1 = require("../../opcodes");
class IterablePresenceReference {
    constructor(artifacts) {
        this.tag = artifacts.tag;
        this.artifacts = artifacts;
    }
    value() {
        return !this.artifacts.isEmpty();
    }
}
opcodes_1.APPEND_OPCODES.add(44 /* PutIterator */, vm => {
    let listRef = vm.frame.getOperand();
    let args = util_1.expect(vm.frame.getArgs(), 'PutIteratorOpcode expects a populated args register');
    let iterable = vm.env.iterableFor(listRef, args);
    let iterator = new reference_1.ReferenceIterator(iterable);
    vm.frame.setIterator(iterator);
    vm.frame.setCondition(new IterablePresenceReference(iterator.artifacts));
});
opcodes_1.APPEND_OPCODES.add(45 /* EnterList */, (vm, { op1: start, op2: end }) => {
    vm.enterList(start, end);
});
opcodes_1.APPEND_OPCODES.add(46 /* ExitList */, vm => vm.exitList());
opcodes_1.APPEND_OPCODES.add(47 /* EnterWithKey */, (vm, { op1: start, op2: end }) => {
    let key = util_1.expect(vm.frame.getKey(), 'EnterWithKeyOpcode expects a populated key register');
    vm.enterWithKey(key, start, end);
});
const TRUE_REF = new reference_1.ConstReference(true);
const FALSE_REF = new reference_1.ConstReference(false);
opcodes_1.APPEND_OPCODES.add(48 /* NextIter */, (vm, { op1: end }) => {
    let item = vm.frame.getIterator().next();
    if (item) {
        vm.frame.setCondition(TRUE_REF);
        vm.frame.setKey(item.key);
        vm.frame.setOperand(item.value);
        vm.frame.setArgs(args_1.EvaluatedArgs.positional([item.value, item.memo]));
    }
    else {
        vm.frame.setCondition(FALSE_REF);
        vm.goto(end);
    }
});
//# sourceMappingURL=data:application/json;base64,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