"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const reference_1 = require("@glimmer/reference");
const vm_1 = require("./vm");
const opcodes_1 = require("../../opcodes");
opcodes_1.APPEND_OPCODES.add(49 /* PutDynamicPartial */, (vm, { op1: _symbolTable }) => {
    let env = vm.env;
    let symbolTable = vm.constants.getOther(_symbolTable);
    function lookupPartial(name) {
        let normalized = String(name);
        if (!env.hasPartial(normalized, symbolTable)) {
            throw new Error(`Could not find a partial named "${normalized}"`);
        }
        return env.lookupPartial(normalized, symbolTable);
    }
    let reference = reference_1.map(vm.frame.getOperand(), lookupPartial);
    let cache = reference_1.isConst(reference) ? undefined : new reference_1.ReferenceCache(reference);
    let definition = cache ? cache.peek() : reference.value();
    vm.frame.setImmediate(definition);
    if (cache) {
        vm.updateWith(new vm_1.Assert(cache));
    }
});
opcodes_1.APPEND_OPCODES.add(50 /* PutPartial */, (vm, { op1: _definition }) => {
    let definition = vm.constants.getOther(_definition);
    vm.frame.setImmediate(definition);
});
opcodes_1.APPEND_OPCODES.add(51 /* EvaluatePartial */, (vm, { op1: _symbolTable, op2: _cache }) => {
    let symbolTable = vm.constants.getOther(_symbolTable);
    let cache = vm.constants.getOther(_cache);
    let { template } = vm.frame.getImmediate();
    let block = cache[template.id];
    if (!block) {
        block = template.asPartial(symbolTable);
    }
    vm.invokePartial(block);
});
//# sourceMappingURL=data:application/json;base64,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