import { OpcodeJSON, UpdatingOpcode } from '../../opcodes';
import { UpdatingVM } from '../../vm';
import { Reference } from '@glimmer/reference';
import { Option, Opaque } from '@glimmer/util';
import { ReferenceCache, RevisionTag } from '@glimmer/reference';
import Environment from '../../environment';
export declare type TestFunction = (ref: Reference<Opaque>, env: Environment) => Reference<boolean>;
export declare const ConstTest: TestFunction;
export declare const SimpleTest: TestFunction;
export declare const EnvironmentTest: TestFunction;
export declare class Assert extends UpdatingOpcode {
    type: string;
    private cache;
    constructor(cache: ReferenceCache<Opaque>);
    evaluate(vm: UpdatingVM): void;
    toJSON(): OpcodeJSON;
}
export declare class JumpIfNotModifiedOpcode extends UpdatingOpcode {
    private target;
    type: string;
    private lastRevision;
    constructor(tag: RevisionTag, target: LabelOpcode);
    evaluate(vm: UpdatingVM): void;
    didModify(): void;
    toJSON(): OpcodeJSON;
}
export declare class DidModifyOpcode extends UpdatingOpcode {
    private target;
    type: string;
    constructor(target: JumpIfNotModifiedOpcode);
    evaluate(): void;
}
export declare class LabelOpcode implements UpdatingOpcode {
    tag: RevisionTag;
    type: string;
    label: Option<string>;
    _guid: number;
    prev: any;
    next: any;
    constructor(label: string);
    evaluate(): void;
    inspect(): string;
    toJSON(): OpcodeJSON;
}
