"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const opcodes_1 = require("../../opcodes");
const reference_1 = require("@glimmer/reference");
const util_1 = require("@glimmer/util");
const reference_2 = require("@glimmer/reference");
const opcodes_2 = require("../../opcodes");
opcodes_2.APPEND_OPCODES.add(0 /* PushChildScope */, vm => vm.pushChildScope());
opcodes_2.APPEND_OPCODES.add(1 /* PopScope */, vm => vm.popScope());
opcodes_2.APPEND_OPCODES.add(2 /* PushDynamicScope */, vm => vm.pushDynamicScope());
opcodes_2.APPEND_OPCODES.add(3 /* PopDynamicScope */, vm => vm.popDynamicScope());
opcodes_2.APPEND_OPCODES.add(4 /* Put */, (vm, { op1: reference }) => {
    vm.frame.setOperand(vm.constants.getReference(reference));
});
opcodes_2.APPEND_OPCODES.add(5 /* EvaluatePut */, (vm, { op1: expression }) => {
    let expr = vm.constants.getExpression(expression);
    vm.evaluateOperand(expr);
});
opcodes_2.APPEND_OPCODES.add(6 /* PutArgs */, (vm, { op1: args }) => {
    vm.evaluateArgs(vm.constants.getExpression(args));
});
opcodes_2.APPEND_OPCODES.add(7 /* BindPositionalArgs */, (vm, { op1: _symbols }) => {
    let symbols = vm.constants.getArray(_symbols);
    vm.bindPositionalArgs(symbols);
});
opcodes_2.APPEND_OPCODES.add(8 /* BindNamedArgs */, (vm, { op1: _names, op2: _symbols }) => {
    let names = vm.constants.getArray(_names);
    let symbols = vm.constants.getArray(_symbols);
    vm.bindNamedArgs(names, symbols);
});
opcodes_2.APPEND_OPCODES.add(9 /* BindBlocks */, (vm, { op1: _names, op2: _symbols }) => {
    let names = vm.constants.getArray(_names);
    let symbols = vm.constants.getArray(_symbols);
    vm.bindBlocks(names, symbols);
});
opcodes_2.APPEND_OPCODES.add(10 /* BindPartialArgs */, (vm, { op1: symbol }) => {
    vm.bindPartialArgs(symbol);
});
opcodes_2.APPEND_OPCODES.add(11 /* BindCallerScope */, vm => vm.bindCallerScope());
opcodes_2.APPEND_OPCODES.add(12 /* BindDynamicScope */, (vm, { op1: _names }) => {
    let names = vm.constants.getArray(_names);
    vm.bindDynamicScope(names);
});
opcodes_2.APPEND_OPCODES.add(13 /* Enter */, (vm, { op1: start, op2: end }) => vm.enter(start, end));
opcodes_2.APPEND_OPCODES.add(14 /* Exit */, (vm) => vm.exit());
opcodes_2.APPEND_OPCODES.add(15 /* Evaluate */, (vm, { op1: _block }) => {
    let block = vm.constants.getBlock(_block);
    let args = vm.frame.getArgs();
    vm.invokeBlock(block, args);
});
opcodes_2.APPEND_OPCODES.add(16 /* Jump */, (vm, { op1: target }) => vm.goto(target));
opcodes_2.APPEND_OPCODES.add(17 /* JumpIf */, (vm, { op1: target }) => {
    let reference = vm.frame.getCondition();
    if (reference_2.isConst(reference)) {
        if (reference.value()) {
            vm.goto(target);
        }
    }
    else {
        let cache = new reference_2.ReferenceCache(reference);
        if (cache.peek()) {
            vm.goto(target);
        }
        vm.updateWith(new Assert(cache));
    }
});
opcodes_2.APPEND_OPCODES.add(18 /* JumpUnless */, (vm, { op1: target }) => {
    let reference = vm.frame.getCondition();
    if (reference_2.isConst(reference)) {
        if (!reference.value()) {
            vm.goto(target);
        }
    }
    else {
        let cache = new reference_2.ReferenceCache(reference);
        if (!cache.peek()) {
            vm.goto(target);
        }
        vm.updateWith(new Assert(cache));
    }
});
exports.ConstTest = function (ref, _env) {
    return new reference_1.ConstReference(!!ref.value());
};
exports.SimpleTest = function (ref, _env) {
    return ref;
};
exports.EnvironmentTest = function (ref, env) {
    return env.toConditionalReference(ref);
};
opcodes_2.APPEND_OPCODES.add(19 /* Test */, (vm, { op1: _func }) => {
    let operand = vm.frame.getOperand();
    let func = vm.constants.getFunction(_func);
    vm.frame.setCondition(func(operand, vm.env));
});
class Assert extends opcodes_1.UpdatingOpcode {
    constructor(cache) {
        super();
        this.type = "assert";
        this.tag = cache.tag;
        this.cache = cache;
    }
    evaluate(vm) {
        let { cache } = this;
        if (reference_2.isModified(cache.revalidate())) {
            vm.throw();
        }
    }
    toJSON() {
        let { type, _guid, cache } = this;
        let expected;
        try {
            expected = JSON.stringify(cache.peek());
        }
        catch (e) {
            expected = String(cache.peek());
        }
        return {
            guid: _guid,
            type,
            args: [],
            details: { expected }
        };
    }
}
exports.Assert = Assert;
class JumpIfNotModifiedOpcode extends opcodes_1.UpdatingOpcode {
    constructor(tag, target) {
        super();
        this.target = target;
        this.type = "jump-if-not-modified";
        this.tag = tag;
        this.lastRevision = tag.value();
    }
    evaluate(vm) {
        let { tag, target, lastRevision } = this;
        if (!vm.alwaysRevalidate && tag.validate(lastRevision)) {
            vm.goto(target);
        }
    }
    didModify() {
        this.lastRevision = this.tag.value();
    }
    toJSON() {
        return {
            guid: this._guid,
            type: this.type,
            args: [JSON.stringify(this.target.inspect())]
        };
    }
}
exports.JumpIfNotModifiedOpcode = JumpIfNotModifiedOpcode;
class DidModifyOpcode extends opcodes_1.UpdatingOpcode {
    constructor(target) {
        super();
        this.target = target;
        this.type = "did-modify";
        this.tag = reference_2.CONSTANT_TAG;
    }
    evaluate() {
        this.target.didModify();
    }
}
exports.DidModifyOpcode = DidModifyOpcode;
class LabelOpcode {
    constructor(label) {
        this.tag = reference_2.CONSTANT_TAG;
        this.type = "label";
        this.label = null;
        this.prev = null;
        this.next = null;
        util_1.initializeGuid(this);
        if (label)
            this.label = label;
    }
    evaluate() { }
    inspect() {
        return `${this.label} [${this._guid}]`;
    }
    toJSON() {
        return {
            guid: this._guid,
            type: this.type,
            args: [JSON.stringify(this.inspect())]
        };
    }
}
exports.LabelOpcode = LabelOpcode;
//# sourceMappingURL=data:application/json;base64,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