import { Environment } from './environment';
import { SymbolTable } from '@glimmer/interfaces';
import { CompiledProgram } from './compiled/blocks';
import { BaselineSyntax, InlineBlock } from './scanner';
import { ComponentBuilder as IComponentBuilder, DynamicDefinition, StaticDefinition } from './opcode-builder';
import OpcodeBuilderDSL from './compiled/opcodes/builder';
import * as Component from './component/interfaces';
export interface CompilableLayout {
    compile(builder: Component.ComponentLayoutBuilder): void;
}
export declare function compileLayout(compilable: CompilableLayout, env: Environment): CompiledProgram;
export declare class ComponentBuilder implements IComponentBuilder {
    private builder;
    private env;
    constructor(builder: OpcodeBuilderDSL);
    static(definition: StaticDefinition, args: BaselineSyntax.Args, _symbolTable: SymbolTable, shadow: InlineBlock): void;
    dynamic(definitionArgs: BaselineSyntax.Args, definition: DynamicDefinition, args: BaselineSyntax.Args, _symbolTable: SymbolTable, shadow: InlineBlock): void;
}
export declare function builder<S extends SymbolTable>(env: Environment, symbolTable: S): OpcodeBuilderDSL;
