"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const content_1 = require("../compiled/opcodes/content");
const upsert_1 = require("../upsert");
const badProtocols = [
    'javascript:',
    'vbscript:'
];
const badTags = [
    'A',
    'BODY',
    'LINK',
    'IMG',
    'IFRAME',
    'BASE',
    'FORM'
];
const badTagsForDataURI = [
    'EMBED'
];
const badAttributes = [
    'href',
    'src',
    'background',
    'action'
];
const badAttributesForDataURI = [
    'src'
];
function has(array, item) {
    return array.indexOf(item) !== -1;
}
function checkURI(tagName, attribute) {
    return (tagName === null || has(badTags, tagName)) && has(badAttributes, attribute);
}
function checkDataURI(tagName, attribute) {
    if (tagName === null)
        return false;
    return has(badTagsForDataURI, tagName) && has(badAttributesForDataURI, attribute);
}
function requiresSanitization(tagName, attribute) {
    return checkURI(tagName, attribute) || checkDataURI(tagName, attribute);
}
exports.requiresSanitization = requiresSanitization;
function sanitizeAttributeValue(env, element, attribute, value) {
    let tagName = null;
    if (value === null || value === undefined) {
        return value;
    }
    if (upsert_1.isSafeString(value)) {
        return value.toHTML();
    }
    if (!element) {
        tagName = null;
    }
    else {
        tagName = element.tagName.toUpperCase();
    }
    let str = content_1.normalizeTextValue(value);
    if (checkURI(tagName, attribute)) {
        let protocol = env.protocolForURL(str);
        if (has(badProtocols, protocol)) {
            return `unsafe:${str}`;
        }
    }
    if (checkDataURI(tagName, attribute)) {
        return `unsafe:${str}`;
    }
    return str;
}
exports.sanitizeAttributeValue = sanitizeAttributeValue;
//# sourceMappingURL=data:application/json;base64,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