import { SymbolTable } from '@glimmer/interfaces';
import { Blocks, Inlines } from './syntax/functions';
import { Constants } from './opcodes';
import * as Simple from './dom/interfaces';
import { DOMChanges, DOMTreeConstruction } from './dom/helper';
import { Reference, PathReference, OpaqueIterable } from '@glimmer/reference';
import { AttributeManager } from './dom/attribute-managers';
import { PartialDefinition } from './partial';
import { ComponentManager, ComponentDefinition } from './component/interfaces';
import { ModifierManager } from './modifier/interfaces';
import { Option, Destroyable, Opaque, HasGuid } from '@glimmer/util';
import { TemplateMeta } from '@glimmer/wire-format';
import { EvaluatedArgs } from './compiled/expressions/args';
import { InlineBlock } from './scanner';
import { PublicVM } from './vm/append';
export declare type ScopeSlot = PathReference<Opaque> | InlineBlock | EvaluatedArgs;
export interface DynamicScope {
    get(key: string): PathReference<Opaque>;
    set(key: string, reference: PathReference<Opaque>): PathReference<Opaque>;
    child(): DynamicScope;
}
export declare class Scope {
    static root(self: PathReference<Opaque>, size?: number): Scope;
    private slots;
    private callerScope;
    constructor(references: ScopeSlot[], callerScope?: Option<Scope>);
    init({self}: {
        self: PathReference<Opaque>;
    }): this;
    getSelf(): PathReference<Opaque>;
    getSymbol(symbol: number): PathReference<Opaque>;
    getBlock(symbol: number): InlineBlock;
    getPartialArgs(symbol: number): EvaluatedArgs;
    bindSymbol(symbol: number, value: PathReference<Opaque>): void;
    bindBlock(symbol: number, value: InlineBlock): void;
    bindPartialArgs(symbol: number, value: EvaluatedArgs): void;
    bindCallerScope(scope: Scope): void;
    getCallerScope(): Option<Scope>;
    child(): Scope;
}
export declare class Opcode {
    private array;
    offset: number;
    constructor(array: Uint32Array | Array<number>);
    readonly type: number;
    readonly op1: number;
    readonly op2: number;
    readonly op3: number;
}
export declare class Program {
    [key: number]: never;
    private opcodes;
    private _offset;
    private _opcode;
    constructor();
    readonly next: number;
    readonly current: number;
    opcode(offset: number): Opcode;
    set(pos: number, type: number, op1?: number, op2?: number, op3?: number): void;
    push(type: number, op1?: number, op2?: number, op3?: number): number;
}
export declare abstract class Environment {
    protected updateOperations: DOMChanges;
    protected appendOperations: DOMTreeConstruction;
    private _macros;
    private _transaction;
    constants: Constants;
    program: Program;
    constructor({appendOperations, updateOperations}: {
        appendOperations: DOMTreeConstruction;
        updateOperations: DOMChanges;
    });
    toConditionalReference(reference: Reference<Opaque>): Reference<boolean>;
    abstract iterableFor(reference: Reference<Opaque>, args: EvaluatedArgs): OpaqueIterable;
    abstract protocolForURL(s: string): string;
    getAppendOperations(): DOMTreeConstruction;
    getDOM(): DOMChanges;
    getIdentity(object: HasGuid): string;
    begin(): void;
    private readonly transaction;
    didCreate<T>(component: T, manager: ComponentManager<T>): void;
    didUpdate<T>(component: T, manager: ComponentManager<T>): void;
    scheduleInstallModifier<T>(modifier: T, manager: ModifierManager<T>): void;
    scheduleUpdateModifier<T>(modifier: T, manager: ModifierManager<T>): void;
    didDestroy(d: Destroyable): void;
    commit(): void;
    attributeFor(element: Simple.Element, attr: string, isTrusting: boolean, namespace?: string): AttributeManager;
    macros(): {
        blocks: Blocks;
        inlines: Inlines;
    };
    abstract hasHelper(helperName: string, blockMeta: TemplateMeta): boolean;
    abstract lookupHelper(helperName: string, blockMeta: TemplateMeta): Helper;
    abstract hasModifier(modifierName: string, blockMeta: TemplateMeta): boolean;
    abstract lookupModifier(modifierName: string, blockMeta: TemplateMeta): ModifierManager<Opaque>;
    abstract hasComponentDefinition(tagName: string, symbolTable: SymbolTable): boolean;
    abstract getComponentDefinition(tagName: string, symbolTable: SymbolTable): ComponentDefinition<Opaque>;
    abstract hasPartial(partialName: string, symbolTable: SymbolTable): boolean;
    abstract lookupPartial(PartialName: string, symbolTable: SymbolTable): PartialDefinition<TemplateMeta>;
}
export default Environment;
export interface Helper {
    (vm: PublicVM, args: EvaluatedArgs, symbolTable: SymbolTable): PathReference<Opaque>;
}
