"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const reference_1 = require("@glimmer/reference");
class DynamicVarReference {
    constructor(scope, nameRef) {
        this.scope = scope;
        this.nameRef = nameRef;
        let varTag = this.varTag = new reference_1.UpdatableTag(reference_1.CONSTANT_TAG);
        this.tag = reference_1.combine([nameRef.tag, varTag]);
    }
    value() {
        return this.getVar().value();
    }
    get(key) {
        return this.getVar().get(key);
    }
    getVar() {
        let name = String(this.nameRef.value());
        let ref = this.scope.get(name);
        this.varTag.update(ref.tag);
        return ref;
    }
}
function getDynamicVar(vm, args, _symbolTable) {
    let scope = vm.dynamicScope();
    let nameRef = args.positional.at(0);
    return new DynamicVarReference(scope, nameRef);
}
exports.default = getDynamicVar;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2V0LWR5bmFtaWMtdmFyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vbGliL2hlbHBlcnMvZ2V0LWR5bmFtaWMtdmFyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBSUEsa0RBQXFHO0FBR3JHO0lBSUUsWUFBb0IsS0FBbUIsRUFBVSxPQUE4QjtRQUEzRCxVQUFLLEdBQUwsS0FBSyxDQUFjO1FBQVUsWUFBTyxHQUFQLE9BQU8sQ0FBdUI7UUFDN0UsSUFBSSxNQUFNLEdBQUcsSUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLHdCQUFZLENBQUMsd0JBQVksQ0FBQyxDQUFDO1FBQzFELElBQUksQ0FBQyxHQUFHLEdBQUcsbUJBQU8sQ0FBQyxDQUFDLE9BQU8sQ0FBQyxHQUFHLEVBQUUsTUFBTSxDQUFDLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBRUQsS0FBSztRQUNILE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLENBQUMsS0FBSyxFQUFFLENBQUM7SUFDL0IsQ0FBQztJQUVELEdBQUcsQ0FBQyxHQUFXO1FBQ2IsTUFBTSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDaEMsQ0FBQztJQUVPLE1BQU07UUFDWixJQUFJLElBQUksR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDO1FBQ3hDLElBQUksR0FBRyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxDQUFDO1FBRS9CLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUU1QixNQUFNLENBQUMsR0FBRyxDQUFDO0lBQ2IsQ0FBQztDQUNGO0FBRUQsdUJBQXVCLEVBQVksRUFBRSxJQUFtQixFQUFFLFlBQXlCO0lBQ2pGLElBQUksS0FBSyxHQUFHLEVBQUUsQ0FBQyxZQUFZLEVBQUUsQ0FBQztJQUM5QixJQUFJLE9BQU8sR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUVwQyxNQUFNLENBQUMsSUFBSSxtQkFBbUIsQ0FBQyxLQUFLLEVBQUUsT0FBTyxDQUFDLENBQUM7QUFDakQsQ0FBQztBQUVELGtCQUFnQixhQUF3QixDQUFDIn0=