import { RevisionTag, ConstReference, PathReference, Reference } from '@glimmer/reference';
import { Opaque } from '@glimmer/util';
export declare type Primitive = undefined | null | boolean | number | string;
export declare class PrimitiveReference<T extends Primitive> extends ConstReference<T> implements PathReference<T> {
    static create<T extends Primitive>(value: T): PrimitiveReference<T>;
    protected constructor(value: T);
    get(_key: string): PrimitiveReference<Primitive>;
}
export declare const UNDEFINED_REFERENCE: PrimitiveReference<undefined>;
export declare const NULL_REFERENCE: PrimitiveReference<null>;
export declare class ConditionalReference implements Reference<boolean> {
    private inner;
    tag: RevisionTag;
    constructor(inner: Reference<Opaque>);
    value(): boolean;
    protected toBool(value: Opaque): boolean;
}
