"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const reference_1 = require("@glimmer/reference");
class PrimitiveReference extends reference_1.ConstReference {
    constructor(value) {
        super(value);
    }
    static create(value) {
        if (value === undefined) {
            return exports.UNDEFINED_REFERENCE;
        }
        else if (value === null) {
            return exports.NULL_REFERENCE;
        }
        else if (value === true) {
            return TRUE_REFERENCE;
        }
        else if (value === false) {
            return FALSE_REFERENCE;
        }
        else if (typeof value === 'number') {
            return new ValueReference(value);
        }
        else {
            return new StringReference(value);
        }
    }
    get(_key) {
        return exports.UNDEFINED_REFERENCE;
    }
}
exports.PrimitiveReference = PrimitiveReference;
class StringReference extends PrimitiveReference {
    constructor() {
        super(...arguments);
        this.lengthReference = null;
    }
    get(key) {
        if (key === 'length') {
            let { lengthReference } = this;
            if (lengthReference === null) {
                lengthReference = this.lengthReference = new ValueReference(this.inner.length);
            }
            return lengthReference;
        }
        else {
            return super.get(key);
        }
    }
}
class ValueReference extends PrimitiveReference {
    constructor(value) {
        super(value);
    }
}
exports.UNDEFINED_REFERENCE = new ValueReference(undefined);
exports.NULL_REFERENCE = new ValueReference(null);
const TRUE_REFERENCE = new ValueReference(true);
const FALSE_REFERENCE = new ValueReference(false);
class ConditionalReference {
    constructor(inner) {
        this.inner = inner;
        this.tag = inner.tag;
    }
    value() {
        return this.toBool(this.inner.value());
    }
    toBool(value) {
        return !!value;
    }
}
exports.ConditionalReference = ConditionalReference;
//# sourceMappingURL=data:application/json;base64,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