import { Option, Dict } from '@glimmer/util';
import { TemplateMeta } from '@glimmer/wire-format';
import { SymbolTable, ProgramSymbolTable as IProgramSymbolTable, BlockSymbolTable as IBlockSymbolTable, Symbols } from '@glimmer/interfaces';
export declare function entryPoint(meta: Option<TemplateMeta>): ProgramSymbolTable;
export declare function layout(meta: TemplateMeta, wireNamed: string[], wireYields: string[], hasPartials: boolean): ProgramSymbolTable;
export declare function block(parent: SymbolTable, locals: string[]): SymbolTable;
export declare class ProgramSymbolTable implements IProgramSymbolTable {
    private meta;
    private named;
    private yields;
    private partialArgs;
    size: number;
    program: this;
    constructor(meta: Option<TemplateMeta>, named?: Option<Dict<number>>, yields?: Option<Dict<number>>, partialArgs?: Option<number>, size?: number);
    getMeta(): Option<TemplateMeta>;
    getSymbols(): Symbols;
    getSymbol(kind: 'local', name: string): null;
    getSymbol(kind: 'local' | 'named' | 'yields', name: string): Option<number>;
    getPartialArgs(): number;
}
export declare class BlockSymbolTable implements IBlockSymbolTable {
    private parent;
    protected program: ProgramSymbolTable;
    private locals;
    constructor(parent: SymbolTable, program: ProgramSymbolTable, locals: Option<Dict<number>>);
    getMeta(): Option<TemplateMeta>;
    getSymbols(): Symbols;
    getSymbol(kind: 'local' | 'named' | 'yields', name: string): Option<number>;
    private getLocal(name);
    getPartialArgs(): Option<number>;
}
export declare const EMPTY_SYMBOL_TABLE: SymbolTable;
