"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("@glimmer/util");
function entryPoint(meta) {
    return new ProgramSymbolTable(meta);
}
exports.entryPoint = entryPoint;
function layout(meta, wireNamed, wireYields, hasPartials) {
    let { named, yields, partialSymbol, size } = symbols(wireNamed, wireYields, hasPartials);
    return new ProgramSymbolTable(meta, named, yields, partialSymbol, size);
}
exports.layout = layout;
function block(parent, locals) {
    let localsMap = null;
    let program = parent['program'];
    if (locals.length !== 0) {
        let map = localsMap = util_1.dict();
        locals.forEach(l => map[l] = program.size++);
    }
    return new BlockSymbolTable(parent, program, localsMap);
}
exports.block = block;
function symbols(named, yields, hasPartials) {
    let yieldsMap = null;
    let namedMap = null;
    let size = 1;
    if (yields.length !== 0) {
        let map = yieldsMap = util_1.dict();
        yields.forEach(y => map[y] = size++);
    }
    if (named.length !== 0) {
        let map = namedMap = util_1.dict();
        named.forEach(y => map[y] = size++);
    }
    let partialSymbol = hasPartials ? size++ : null;
    return { named: namedMap, yields: yieldsMap, partialSymbol, size };
}
class ProgramSymbolTable {
    constructor(meta, named = null, yields = null, partialArgs = null, size = 1) {
        this.meta = meta;
        this.named = named;
        this.yields = yields;
        this.partialArgs = partialArgs;
        this.size = size;
        this.program = this;
    }
    getMeta() {
        return this.meta;
    }
    getSymbols() {
        return {
            named: this.named,
            yields: this.yields,
            locals: null,
            partialArgs: this.partialArgs
        };
    }
    getSymbol(kind, name) {
        if (kind === 'local')
            return null;
        return this[kind] && this[kind][name];
    }
    getPartialArgs() {
        return this.partialArgs || 0;
    }
}
exports.ProgramSymbolTable = ProgramSymbolTable;
class BlockSymbolTable {
    constructor(parent, program, locals) {
        this.parent = parent;
        this.program = program;
        this.locals = locals;
    }
    getMeta() {
        return this.program.getMeta();
    }
    getSymbols() {
        return {
            named: null,
            yields: null,
            locals: this.locals,
            partialArgs: null
        };
    }
    getSymbol(kind, name) {
        if (kind === 'local') {
            return this.getLocal(name);
        }
        else {
            return this.program.getSymbol(kind, name);
        }
    }
    getLocal(name) {
        let { locals, parent } = this;
        let symbol = locals && locals[name];
        if (!symbol && parent) {
            symbol = parent.getSymbol('local', name);
        }
        return symbol;
    }
    getPartialArgs() {
        return this.program.getPartialArgs();
    }
}
exports.BlockSymbolTable = BlockSymbolTable;
exports.EMPTY_SYMBOL_TABLE = {
    getMeta() {
        return null;
    },
    getSymbols() {
        return {
            named: null,
            yields: null,
            locals: null,
            partialArgs: null
        };
    },
    getSymbol(_kind, _name) {
        throw new Error("BUG: Calling getSymbol on EMPTY_SYMBOL_TABLE");
    },
    getPartialArgs() {
        return null;
    }
};
//# sourceMappingURL=data:application/json;base64,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