import * as WireFormat from '@glimmer/wire-format';
import OpcodeBuilder from '../compiled/opcodes/builder';
import { CompiledExpression } from '../compiled/expressions';
import { BaselineSyntax } from '../scanner';
import { Opaque, Option } from '@glimmer/util';
import { CompiledArgs, Blocks as BlocksSyntax } from '../compiled/expressions/args';
export declare type SexpExpression = BaselineSyntax.AnyExpression & {
    0: number;
};
export declare type Syntax = SexpExpression | BaselineSyntax.AnyStatement;
export declare type CompilerFunction<T extends Syntax, U> = ((sexp: T, builder: OpcodeBuilder) => U);
export declare type Name = BaselineSyntax.AnyStatement[0];
export declare type debugGet = ((path: string) => any);
export interface DebugContext {
    context: Opaque;
    get: debugGet;
}
export declare type debugCallback = ((context: Opaque, get: debugGet) => DebugContext);
export declare function setDebuggerCallback(cb: debugCallback): void;
export declare function resetDebuggerCallback(): void;
export declare class Compilers<T extends Syntax, CompileTo> {
    private names;
    private funcs;
    add(name: number, func: CompilerFunction<T, CompileTo>): void;
    compile(sexp: T, builder: OpcodeBuilder): CompileTo;
}
export declare const STATEMENTS: Compilers<BaselineSyntax.AnyStatement, void>;
import C = WireFormat.Core;
export declare function expr(expression: BaselineSyntax.AnyExpression, builder: OpcodeBuilder): CompiledExpression<Opaque>;
export declare function compileArgs(params: Option<WireFormat.Core.Params>, hash: Option<WireFormat.Core.Hash>, builder: OpcodeBuilder): CompiledArgs;
export declare function compileBlockArgs(params: Option<WireFormat.Core.Params>, hash: Option<WireFormat.Core.Hash>, blocks: BlocksSyntax, builder: OpcodeBuilder): CompiledArgs;
export declare function compileBaselineArgs(args: BaselineSyntax.Args, builder: OpcodeBuilder): CompiledArgs;
export declare type NestedBlockSyntax = BaselineSyntax.NestedBlock;
export declare type CompileBlockMacro = (sexp: NestedBlockSyntax, builder: OpcodeBuilder) => void;
export declare class Blocks {
    private names;
    private funcs;
    private missing;
    add(name: string, func: CompileBlockMacro): void;
    addMissing(func: CompileBlockMacro): void;
    compile(sexp: BaselineSyntax.NestedBlock, builder: OpcodeBuilder): void;
}
export declare const BLOCKS: Blocks;
export declare type AppendSyntax = BaselineSyntax.OptimizedAppend | BaselineSyntax.UnoptimizedAppend;
export declare type AppendMacro = (path: C.Path, params: Option<C.Params>, hash: Option<C.Hash>, builder: OpcodeBuilder) => ['expr', BaselineSyntax.AnyExpression] | true | false;
export declare class Inlines {
    private names;
    private funcs;
    private missing;
    add(name: string, func: AppendMacro): void;
    addMissing(func: AppendMacro): void;
    compile(sexp: AppendSyntax, builder: OpcodeBuilder): ['expr', BaselineSyntax.AnyExpression] | true;
}
export declare const INLINES: Inlines;
export declare function populateBuiltins(blocks?: Blocks, inlines?: Inlines): {
    blocks: Blocks;
    inlines: Inlines;
};
