"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("@glimmer/util");
const builder_1 = require("./builder");
const vm_1 = require("./vm");
const scanner_1 = require("./scanner");
class TemplateIterator {
    constructor(vm) {
        this.vm = vm;
    }
    next() {
        return this.vm.next();
    }
}
exports.TemplateIterator = TemplateIterator;
let clientId = 0;
function templateFactory({ id: templateId, meta, block }) {
    let parsedBlock;
    let id = templateId || `client-${clientId++}`;
    let create = (env, envMeta) => {
        let newMeta = envMeta ? util_1.assign({}, envMeta, meta) : meta;
        if (!parsedBlock) {
            parsedBlock = JSON.parse(block);
        }
        return template(parsedBlock, id, newMeta, env);
    };
    return { id, meta, create };
}
exports.default = templateFactory;
function template(block, id, meta, env) {
    let scanner = new scanner_1.default(block, meta, env);
    let entryPoint;
    let asEntryPoint = () => {
        if (!entryPoint)
            entryPoint = scanner.scanEntryPoint();
        return entryPoint;
    };
    let layout;
    let asLayout = () => {
        if (!layout)
            layout = scanner.scanLayout();
        return layout;
    };
    let asPartial = (symbols) => scanner.scanPartial(symbols);
    let render = (self, appendTo, dynamicScope) => {
        let elementStack = builder_1.ElementStack.forInitialRender(env, appendTo, null);
        let compiled = asEntryPoint().compile(env);
        let vm = vm_1.VM.initial(env, self, dynamicScope, elementStack, compiled);
        return new TemplateIterator(vm);
    };
    return { id, meta, _block: block, asEntryPoint, asLayout, asPartial, render };
}
//# sourceMappingURL=data:application/json;base64,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