import { Opaque } from '@glimmer/util';
import { DOMChanges, DOMTreeConstruction } from './dom/helper';
import { Bounds, Cursor } from './bounds';
export interface SafeString {
    toHTML(): string;
}
export declare function isSafeString(value: Opaque): value is SafeString;
export declare function isNode(value: Opaque): value is Node;
export declare function isString(value: Opaque): value is string;
export declare type Insertion = CautiousInsertion | TrustingInsertion;
export declare type CautiousInsertion = string | SafeString | Node;
export declare type TrustingInsertion = string | Node;
declare abstract class Upsert {
    bounds: Bounds;
    constructor(bounds: Bounds);
    abstract update(dom: DOMChanges, value: Insertion): boolean;
}
export default Upsert;
export declare function cautiousInsert(dom: DOMTreeConstruction, cursor: Cursor, value: CautiousInsertion): Upsert;
export declare function trustingInsert(dom: DOMTreeConstruction, cursor: Cursor, value: TrustingInsertion): Upsert;
