"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("@glimmer/util");
class CapturedFrame {
    constructor(operand, args, condition) {
        this.operand = operand;
        this.args = args;
        this.condition = condition;
    }
}
exports.CapturedFrame = CapturedFrame;
class Frame {
    constructor(start, end, component = null, manager = null, shadow = null) {
        this.start = start;
        this.end = end;
        this.component = component;
        this.manager = manager;
        this.shadow = shadow;
        this.operand = null;
        this.immediate = null;
        this.args = null;
        this.callerScope = null;
        this.blocks = null;
        this.condition = null;
        this.iterator = null;
        this.key = null;
        this.ip = start;
    }
    capture() {
        return new CapturedFrame(this.operand, this.args, this.condition);
    }
    restore(frame) {
        this.operand = frame.operand;
        this.args = frame.args;
        this.condition = frame.condition;
    }
}
class FrameStack {
    constructor() {
        this.frames = [];
        this.frame = -1;
    }
    get currentFrame() {
        return this.frames[this.frame];
    }
    push(start, end, component = null, manager = null, shadow = null) {
        let pos = ++this.frame;
        if (pos < this.frames.length) {
            let frame = this.frames[pos];
            frame.start = frame.ip = start;
            frame.end = end;
            frame.component = component;
            frame.manager = manager;
            frame.shadow = shadow;
            frame.operand = null;
            frame.immediate = null;
            frame.args = null;
            frame.callerScope = null;
            frame.blocks = null;
            frame.condition = null;
            frame.iterator = null;
            frame.key = null;
        }
        else {
            this.frames[pos] = new Frame(start, end, component, manager, shadow);
        }
    }
    pop() {
        this.frame--;
    }
    capture() {
        return this.currentFrame.capture();
    }
    restore(frame) {
        this.currentFrame.restore(frame);
    }
    getStart() {
        return this.currentFrame.start;
    }
    getEnd() {
        return this.currentFrame.end;
    }
    getCurrent() {
        return this.currentFrame.ip;
    }
    setCurrent(ip) {
        return this.currentFrame.ip = ip;
    }
    getOperand() {
        return util_1.unwrap(this.currentFrame.operand);
    }
    setOperand(operand) {
        return this.currentFrame.operand = operand;
    }
    getImmediate() {
        return this.currentFrame.immediate;
    }
    setImmediate(value) {
        return this.currentFrame.immediate = value;
    }
    // FIXME: These options are required in practice by the existing code, but
    // figure out why.
    getArgs() {
        return this.currentFrame.args;
    }
    setArgs(args) {
        return this.currentFrame.args = args;
    }
    getCondition() {
        return util_1.unwrap(this.currentFrame.condition);
    }
    setCondition(condition) {
        return this.currentFrame.condition = condition;
    }
    getIterator() {
        return util_1.unwrap(this.currentFrame.iterator);
    }
    setIterator(iterator) {
        return this.currentFrame.iterator = iterator;
    }
    getKey() {
        return this.currentFrame.key;
    }
    setKey(key) {
        return this.currentFrame.key = key;
    }
    getBlocks() {
        return util_1.unwrap(this.currentFrame.blocks);
    }
    setBlocks(blocks) {
        return this.currentFrame.blocks = blocks;
    }
    getCallerScope() {
        return util_1.unwrap(this.currentFrame.callerScope);
    }
    setCallerScope(callerScope) {
        return this.currentFrame.callerScope = callerScope;
    }
    getComponent() {
        return util_1.unwrap(this.currentFrame.component);
    }
    getManager() {
        return util_1.unwrap(this.currentFrame.manager);
    }
    getShadow() {
        return this.currentFrame.shadow;
    }
    goto(ip) {
        this.setCurrent(ip);
    }
    nextStatement(env) {
        while (this.frame !== -1) {
            let frame = this.frames[this.frame];
            let ip = frame.ip;
            let end = frame.end;
            if (ip < end) {
                let program = env.program;
                frame.ip += 4;
                return program.opcode(ip);
            }
            else {
                this.pop();
            }
        }
        return null;
    }
}
exports.FrameStack = FrameStack;
//# sourceMappingURL=data:application/json;base64,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