import { Option, LinkedList } from '@glimmer/util';
import Environment from '../environment';
import { DestroyableBounds } from '../bounds';
import { ExceptionHandler } from './update';
import { UpdatingOpcode } from '../opcodes';
import * as Simple from '../dom/interfaces';
export default class RenderResult implements DestroyableBounds, ExceptionHandler {
    private env;
    private updating;
    private bounds;
    constructor(env: Environment, updating: LinkedList<UpdatingOpcode>, bounds: DestroyableBounds);
    rerender({alwaysRevalidate}?: {
        alwaysRevalidate?: false;
    }): void;
    parentElement(): Simple.Element;
    firstNode(): Option<Simple.Node>;
    lastNode(): Option<Simple.Node>;
    opcodes(): LinkedList<UpdatingOpcode>;
    handleException(): void;
    destroy(): void;
}
