import * as Simple from './dom/interfaces';
import { Option, Destroyable } from '@glimmer/util';
export interface Bounds {
    parentElement(): Simple.Element;
    firstNode(): Option<Simple.Node>;
    lastNode(): Option<Simple.Node>;
}
export declare class Cursor {
    element: Simple.Element;
    nextSibling: Option<Simple.Node>;
    constructor(element: Simple.Element, nextSibling: Option<Simple.Node>);
}
export default Bounds;
export interface DestroyableBounds extends Bounds, Destroyable {
}
export declare class RealDOMBounds implements Bounds {
    private bounds;
    constructor(bounds: Bounds);
    parentElement(): Element;
    firstNode(): Node;
    lastNode(): Node;
}
export declare class ConcreteBounds implements Bounds {
    parentNode: Simple.Element;
    private first;
    private last;
    constructor(parentNode: Simple.Element, first: Option<Simple.Node>, last: Option<Simple.Node>);
    parentElement(): Simple.Element;
    firstNode(): Option<Simple.Node>;
    lastNode(): Option<Simple.Node>;
}
export declare class SingleNodeBounds implements Bounds {
    private parentNode;
    private node;
    constructor(parentNode: Simple.Element, node: Simple.Node);
    parentElement(): Element;
    firstNode(): Node;
    lastNode(): Node;
}
export declare function bounds(parent: Simple.Element, first: Simple.Node, last: Simple.Node): Bounds;
export declare function single(parent: Simple.Element, node: Simple.Node): Bounds;
export declare function move(bounds: Bounds, reference: Option<Simple.Node>): Option<Simple.Node>;
export declare function clear(bounds: Bounds): Option<Simple.Node>;
