export class Cursor {
    constructor(element, nextSibling) {
        this.element = element;
        this.nextSibling = nextSibling;
    }
}
export class RealDOMBounds {
    constructor(bounds) {
        this.bounds = bounds;
    }
    parentElement() { return this.bounds.parentElement(); }
    firstNode() { return this.bounds.firstNode(); }
    lastNode() { return this.bounds.lastNode(); }
}
export class ConcreteBounds {
    constructor(parentNode, first, last) {
        this.parentNode = parentNode;
        this.first = first;
        this.last = last;
    }
    parentElement() { return this.parentNode; }
    firstNode() { return this.first; }
    lastNode() { return this.last; }
}
export class SingleNodeBounds {
    constructor(parentNode, node) {
        this.parentNode = parentNode;
        this.node = node;
    }
    parentElement() { return this.parentNode; }
    firstNode() { return this.node; }
    lastNode() { return this.node; }
}
export function bounds(parent, first, last) {
    return new ConcreteBounds(parent, first, last);
}
export function single(parent, node) {
    return new SingleNodeBounds(parent, node);
}
export function move(bounds, reference) {
    let parent = bounds.parentElement();
    let first = bounds.firstNode();
    let last = bounds.lastNode();
    let node = first;
    while (node) {
        let next = node.nextSibling;
        parent.insertBefore(node, reference);
        if (node === last)
            return next;
        node = next;
    }
    return null;
}
export function clear(bounds) {
    let parent = bounds.parentElement();
    let first = bounds.firstNode();
    let last = bounds.lastNode();
    let node = first;
    while (node) {
        let next = node.nextSibling;
        parent.removeChild(node);
        if (node === last)
            return next;
        node = next;
    }
    return null;
}
//# sourceMappingURL=data:application/json;base64,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