import Bounds, { Cursor, DestroyableBounds } from './bounds';
import { DOMChanges, DOMTreeConstruction } from './dom/helper';
import { Option, Destroyable, LinkedList, LinkedListNode } from '@glimmer/util';
import { Environment } from './environment';
import { VM } from './vm';
import { PathReference } from '@glimmer/reference';
import * as Simple from './dom/interfaces';
export interface FirstNode {
    firstNode(): Option<Simple.Node>;
}
export interface LastNode {
    lastNode(): Option<Simple.Node>;
}
export interface ElementOperations {
    addStaticAttribute(element: Simple.Element, name: string, value: string): void;
    addStaticAttributeNS(element: Simple.Element, namespace: string, name: string, value: string): void;
    addDynamicAttribute(element: Simple.Element, name: string, value: PathReference<string>, isTrusting: boolean): void;
    addDynamicAttributeNS(element: Simple.Element, namespace: string, name: string, value: PathReference<string>, isTrusting: boolean): void;
    flush(element: Simple.Element, vm: VM): void;
}
export declare class Fragment implements Bounds {
    private bounds;
    constructor(bounds: Bounds);
    parentElement(): Simple.Element;
    firstNode(): Option<Simple.Node>;
    lastNode(): Option<Simple.Node>;
    update(bounds: Bounds): void;
}
export declare class ElementStack implements Cursor {
    nextSibling: Option<Simple.Node>;
    dom: DOMTreeConstruction;
    updateOperations: DOMChanges;
    constructing: Option<Simple.Element>;
    operations: Option<ElementOperations>;
    element: Simple.Element;
    env: Environment;
    private elementStack;
    private nextSiblingStack;
    private blockStack;
    private defaultOperations;
    static forInitialRender(env: Environment, parentNode: Simple.Element, nextSibling: Option<Simple.Node>): ElementStack;
    static resume(env: Environment, tracker: Tracker, nextSibling: Option<Simple.Node>): ElementStack;
    constructor(env: Environment, parentNode: Simple.Element, nextSibling: Option<Simple.Node>);
    expectConstructing(method: string): Simple.Element;
    expectOperations(method: string): ElementOperations;
    block(): Tracker;
    popElement(): Option<Simple.Element>;
    pushSimpleBlock(): Tracker;
    pushUpdatableBlock(): UpdatableTracker;
    private pushBlockTracker(tracker, isRemote?);
    pushBlockList(list: LinkedList<LinkedListNode & Bounds & Destroyable>): Tracker;
    popBlock(): Tracker;
    openElement(tag: string, operations?: ElementOperations): Simple.Element;
    flushElement(): void;
    pushRemoteElement(element: Simple.Element): void;
    popRemoteElement(): void;
    private pushElement(element);
    newDestroyable(d: Destroyable): void;
    newBounds(bounds: Bounds): void;
    appendText(string: string): Simple.Text;
    appendComment(string: string): Simple.Comment;
    setStaticAttribute(name: string, value: string): void;
    setStaticAttributeNS(namespace: string, name: string, value: string): void;
    setDynamicAttribute(name: string, reference: PathReference<string>, isTrusting: boolean): void;
    setDynamicAttributeNS(namespace: string, name: string, reference: PathReference<string>, isTrusting: boolean): void;
    closeElement(): void;
}
export interface Tracker extends DestroyableBounds {
    openElement(element: Simple.Element): void;
    closeElement(): void;
    newNode(node: Simple.Node): void;
    newBounds(bounds: Bounds): void;
    newDestroyable(d: Destroyable): void;
    finalize(stack: ElementStack): void;
}
export declare class SimpleBlockTracker implements Tracker {
    private parent;
    protected first: Option<FirstNode>;
    protected last: Option<LastNode>;
    protected destroyables: Option<Destroyable[]>;
    protected nesting: number;
    constructor(parent: Simple.Element);
    destroy(): void;
    parentElement(): Simple.Element;
    firstNode(): Option<Simple.Node>;
    lastNode(): Option<Simple.Node>;
    openElement(element: Element): void;
    closeElement(): void;
    newNode(node: Node): void;
    newBounds(bounds: Bounds): void;
    newDestroyable(d: Destroyable): void;
    finalize(stack: ElementStack): void;
}
export interface UpdatableTracker extends Tracker {
    reset(env: Environment): Option<Simple.Node>;
}
export declare class UpdatableBlockTracker extends SimpleBlockTracker implements UpdatableTracker {
    reset(env: Environment): Option<Simple.Node>;
}
