import VM from '../../vm/append';
import { COMPILED_EMPTY_POSITIONAL_ARGS, CompiledPositionalArgs, EvaluatedPositionalArgs } from './positional-args';
import { COMPILED_EMPTY_NAMED_ARGS, CompiledNamedArgs, EvaluatedNamedArgs } from './named-args';
import { RevisionTag, PathReference } from '@glimmer/reference';
import { InlineBlock } from '../../scanner';
import { Opaque, Option, Dict } from '@glimmer/util';
export { COMPILED_EMPTY_POSITIONAL_ARGS, COMPILED_EMPTY_NAMED_ARGS };
export interface Blocks {
    default: Option<InlineBlock>;
    inverse: Option<InlineBlock>;
}
export declare const EMPTY_BLOCKS: Blocks;
export declare class CompiledArgs {
    positional: CompiledPositionalArgs;
    named: CompiledNamedArgs;
    blocks: Blocks;
    static create(positional: CompiledPositionalArgs, named: CompiledNamedArgs, blocks: Blocks): CompiledArgs;
    static empty(): CompiledArgs;
    type: string;
    constructor(positional: CompiledPositionalArgs, named: CompiledNamedArgs, blocks: Blocks);
    evaluate(vm: VM): EvaluatedArgs;
}
export declare const COMPILED_EMPTY_ARGS: CompiledArgs;
export declare class EvaluatedArgs {
    positional: EvaluatedPositionalArgs;
    named: EvaluatedNamedArgs;
    blocks: Blocks;
    static empty(): EvaluatedArgs;
    static create(positional: EvaluatedPositionalArgs, named: EvaluatedNamedArgs, blocks: Blocks): EvaluatedArgs;
    static positional(values: PathReference<Opaque>[], blocks?: Blocks): EvaluatedArgs;
    static named(map: Dict<PathReference<Opaque>>, blocks?: Blocks): EvaluatedArgs;
    tag: RevisionTag;
    constructor(positional: EvaluatedPositionalArgs, named: EvaluatedNamedArgs, blocks: Blocks);
}
export { CompiledPositionalArgs, EvaluatedPositionalArgs, CompiledNamedArgs, EvaluatedNamedArgs };
