import { COMPILED_EMPTY_POSITIONAL_ARGS, EVALUATED_EMPTY_POSITIONAL_ARGS, CompiledPositionalArgs, EvaluatedPositionalArgs } from './positional-args';
import { COMPILED_EMPTY_NAMED_ARGS, EVALUATED_EMPTY_NAMED_ARGS, CompiledNamedArgs, EvaluatedNamedArgs } from './named-args';
import { combineTagged } from '@glimmer/reference';
export { COMPILED_EMPTY_POSITIONAL_ARGS, COMPILED_EMPTY_NAMED_ARGS };
export const EMPTY_BLOCKS = {
    default: null,
    inverse: null
};
export class CompiledArgs {
    constructor(positional, named, blocks) {
        this.positional = positional;
        this.named = named;
        this.blocks = blocks;
        this.type = "compiled-args";
    }
    static create(positional, named, blocks) {
        if (positional === COMPILED_EMPTY_POSITIONAL_ARGS && named === COMPILED_EMPTY_NAMED_ARGS && blocks === EMPTY_BLOCKS) {
            return this.empty();
        }
        else {
            return new this(positional, named, blocks);
        }
    }
    static empty() {
        return COMPILED_EMPTY_ARGS;
    }
    evaluate(vm) {
        let { positional, named, blocks } = this;
        return EvaluatedArgs.create(positional.evaluate(vm), named.evaluate(vm), blocks);
    }
}
export const COMPILED_EMPTY_ARGS = new (class extends CompiledArgs {
    constructor() {
        super(COMPILED_EMPTY_POSITIONAL_ARGS, COMPILED_EMPTY_NAMED_ARGS, EMPTY_BLOCKS);
    }
    evaluate(_vm) {
        return EMPTY_EVALUATED_ARGS;
    }
});
export class EvaluatedArgs {
    constructor(positional, named, blocks) {
        this.positional = positional;
        this.named = named;
        this.blocks = blocks;
        this.tag = combineTagged([positional, named]);
    }
    static empty() {
        return EMPTY_EVALUATED_ARGS;
    }
    static create(positional, named, blocks) {
        return new this(positional, named, blocks);
    }
    static positional(values, blocks = EMPTY_BLOCKS) {
        return new this(EvaluatedPositionalArgs.create(values), EVALUATED_EMPTY_NAMED_ARGS, blocks);
    }
    static named(map, blocks = EMPTY_BLOCKS) {
        return new this(EVALUATED_EMPTY_POSITIONAL_ARGS, EvaluatedNamedArgs.create(map), blocks);
    }
}
const EMPTY_EVALUATED_ARGS = new EvaluatedArgs(EVALUATED_EMPTY_POSITIONAL_ARGS, EVALUATED_EMPTY_NAMED_ARGS, EMPTY_BLOCKS);
export { CompiledPositionalArgs, EvaluatedPositionalArgs, CompiledNamedArgs, EvaluatedNamedArgs };
//# sourceMappingURL=data:application/json;base64,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