import { PathReference } from '@glimmer/reference';
import { CompiledExpression } from '../expressions';
import { PublicVM as VM } from '../../vm';
import { SymbolTable } from '@glimmer/interfaces';
export declare type FunctionExpression<T> = (VM: VM, symbolTable: SymbolTable) => PathReference<T>;
export declare class CompiledFunctionExpression<T> extends CompiledExpression<T> {
    private func;
    private symbolTable;
    type: string;
    constructor(func: FunctionExpression<T>, symbolTable: SymbolTable);
    evaluate(vm: VM): PathReference<T>;
    toJSON(): string;
}
