import { CompiledExpression } from '../expressions';
export class CompiledFunctionExpression extends CompiledExpression {
    constructor(func, symbolTable) {
        super();
        this.func = func;
        this.symbolTable = symbolTable;
        this.type = "function";
        this.func = func;
    }
    evaluate(vm) {
        let { func, symbolTable } = this;
        return func(vm, symbolTable);
    }
    toJSON() {
        let { func } = this;
        if (func.name) {
            return `\`${func.name}(...)\``;
        }
        else {
            return "`func(...)`";
        }
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZnVuY3Rpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9saWIvY29tcGlsZWQvZXhwcmVzc2lvbnMvZnVuY3Rpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQ0EsT0FBTyxFQUFFLGtCQUFrQixFQUFFLE1BQU0sZ0JBQWdCLENBQUM7QUFNcEQsTUFBTSxpQ0FBcUMsU0FBUSxrQkFBcUI7SUFHdEUsWUFBb0IsSUFBMkIsRUFBVSxXQUF3QjtRQUMvRSxLQUFLLEVBQUUsQ0FBQztRQURVLFNBQUksR0FBSixJQUFJLENBQXVCO1FBQVUsZ0JBQVcsR0FBWCxXQUFXLENBQWE7UUFGMUUsU0FBSSxHQUFHLFVBQVUsQ0FBQztRQUl2QixJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQztJQUNuQixDQUFDO0lBRUQsUUFBUSxDQUFDLEVBQU07UUFDYixJQUFJLEVBQUUsSUFBSSxFQUFFLFdBQVcsRUFBRSxHQUFHLElBQUksQ0FBQztRQUNqQyxNQUFNLENBQUMsSUFBSSxDQUFDLEVBQUUsRUFBRSxXQUFXLENBQUMsQ0FBQztJQUMvQixDQUFDO0lBRUQsTUFBTTtRQUNKLElBQUksRUFBRSxJQUFJLEVBQUUsR0FBRyxJQUFJLENBQUM7UUFFcEIsRUFBRSxDQUFDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7WUFDZCxNQUFNLENBQUMsS0FBSyxJQUFJLENBQUMsSUFBSSxTQUFTLENBQUM7UUFDakMsQ0FBQztRQUFDLElBQUksQ0FBQyxDQUFDO1lBQ04sTUFBTSxDQUFDLGFBQWEsQ0FBQztRQUN2QixDQUFDO0lBQ0gsQ0FBQztDQUNGIn0=